/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.classification.predict;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphStoreUpdater;
import org.neo4j.gds.MutateComputationResultConsumer;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.ml.pipeline.node.PredictMutateResult;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPipelineResult;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictConfigPreProcessor;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictPipelineAlgorithmFactory;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictPipelineExecutor;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictPipelineMutateConfig;
import org.neo4j.gds.ml.pipeline.node.classification.predict.PredictedProbabilities;
import org.neo4j.gds.result.AbstractResultBuilder;

@GdsCallable(name="gds.beta.pipeline.nodeClassification.predict.mutate", description="Predicts classes for all nodes based on a previously trained pipeline model", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class NodeClassificationPipelineMutateSpec
implements AlgorithmSpec<NodeClassificationPredictPipelineExecutor, NodeClassificationPipelineResult, NodeClassificationPredictPipelineMutateConfig, Stream<PredictMutateResult>, NodeClassificationPredictPipelineAlgorithmFactory<NodeClassificationPredictPipelineMutateConfig>> {
    public String name() {
        return "NodeClassificationPipelineMutate";
    }

    public NodeClassificationPredictPipelineAlgorithmFactory<NodeClassificationPredictPipelineMutateConfig> algorithmFactory(ExecutionContext executionContext) {
        return new NodeClassificationPredictPipelineAlgorithmFactory<NodeClassificationPredictPipelineMutateConfig>(executionContext);
    }

    public NewConfigFunction<NodeClassificationPredictPipelineMutateConfig> newConfigFunction() {
        return NodeClassificationPredictPipelineMutateConfig::of;
    }

    public ComputationResultConsumer<NodeClassificationPredictPipelineExecutor, NodeClassificationPipelineResult, NodeClassificationPredictPipelineMutateConfig, Stream<PredictMutateResult>> computationResultConsumer() {
        return new MutateComputationResultConsumer<NodeClassificationPredictPipelineExecutor, NodeClassificationPipelineResult, NodeClassificationPredictPipelineMutateConfig, PredictMutateResult>((computationResult, executionContext) -> new PredictMutateResult.Builder()){

            protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, ComputationResult<NodeClassificationPredictPipelineExecutor, NodeClassificationPipelineResult, NodeClassificationPredictPipelineMutateConfig> computationResult, ExecutionContext executionContext) {
                GraphStoreUpdater.UpdateGraphStore(resultBuilder, computationResult, (ExecutionContext)executionContext, PredictedProbabilities.asProperties(computationResult.result(), ((NodeClassificationPredictPipelineMutateConfig)computationResult.config()).mutateProperty(), ((NodeClassificationPredictPipelineMutateConfig)computationResult.config()).predictedProbabilityProperty()));
            }
        };
    }

    public void preProcessConfig(Map<String, Object> userInput, ExecutionContext executionContext) {
        NodeClassificationPredictConfigPreProcessor.enhanceInputWithPipelineParameters(userInput, executionContext);
    }
}

