/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.classification.predict;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.WriteNodePropertiesComputationResultConsumer;
import org.neo4j.gds.WriteNodePropertyListFunction;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPipelineResult;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictConfigPreProcessor;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictPipelineAlgorithmFactory;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictPipelineExecutor;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictPipelineWriteConfig;
import org.neo4j.gds.ml.pipeline.node.classification.predict.PredictedProbabilities;
import org.neo4j.gds.ml.pipeline.node.classification.predict.WriteResult;

@GdsCallable(name="gds.beta.pipeline.nodeClassification.predict.write", description="Predicts classes for all nodes based on a previously trained pipeline model", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class NodeClassificationPipelineWriteSpec
implements AlgorithmSpec<NodeClassificationPredictPipelineExecutor, NodeClassificationPipelineResult, NodeClassificationPredictPipelineWriteConfig, Stream<WriteResult>, NodeClassificationPredictPipelineAlgorithmFactory<NodeClassificationPredictPipelineWriteConfig>> {
    public String name() {
        return "NodeClassificationPipelineWrite";
    }

    public NodeClassificationPredictPipelineAlgorithmFactory<NodeClassificationPredictPipelineWriteConfig> algorithmFactory(ExecutionContext executionContext) {
        return new NodeClassificationPredictPipelineAlgorithmFactory<NodeClassificationPredictPipelineWriteConfig>(executionContext);
    }

    public NewConfigFunction<NodeClassificationPredictPipelineWriteConfig> newConfigFunction() {
        return NodeClassificationPredictPipelineWriteConfig::of;
    }

    public ComputationResultConsumer<NodeClassificationPredictPipelineExecutor, NodeClassificationPipelineResult, NodeClassificationPredictPipelineWriteConfig, Stream<WriteResult>> computationResultConsumer() {
        WriteNodePropertyListFunction<NodeClassificationPredictPipelineExecutor, NodeClassificationPipelineResult, NodeClassificationPredictPipelineWriteConfig> writeNodePropertyListFunction = new WriteNodePropertyListFunction<NodeClassificationPredictPipelineExecutor, NodeClassificationPipelineResult, NodeClassificationPredictPipelineWriteConfig>(){

            public List<NodeProperty> apply(ComputationResult<NodeClassificationPredictPipelineExecutor, NodeClassificationPipelineResult, NodeClassificationPredictPipelineWriteConfig> computationResult) {
                return PredictedProbabilities.asProperties(computationResult.result(), ((NodeClassificationPredictPipelineWriteConfig)computationResult.config()).writeProperty(), ((NodeClassificationPredictPipelineWriteConfig)computationResult.config()).predictedProbabilityProperty());
            }
        };
        return new WriteNodePropertiesComputationResultConsumer((computationResult, executionContext) -> new WriteResult.Builder(), (WriteNodePropertyListFunction)writeNodePropertyListFunction, this.name());
    }

    public void preProcessConfig(Map<String, Object> userInput, ExecutionContext executionContext) {
        NodeClassificationPredictConfigPreProcessor.enhanceInputWithPipelineParameters(userInput, executionContext);
    }
}

