/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.classification.predict;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPipelineResult;

final class PredictedProbabilities {
    private PredictedProbabilities() {
    }

    @NotNull
    static List<NodeProperty> asProperties(Optional<NodeClassificationPipelineResult> result, String propertyName, Optional<String> predictedProbabilityProperty) {
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NodeProperty> nodeProperties = new ArrayList<NodeProperty>();
        LongNodePropertyValues classProperties = result.get().predictedClasses().asNodeProperties();
        nodeProperties.add(NodeProperty.of((String)propertyName, (NodePropertyValues)classProperties));
        if (result.get().predictedProbabilities().isEmpty()) {
            return nodeProperties;
        }
        NodePropertyValues nodePropertyValues = result.get().predictedProbabilities().get().asNodeProperties();
        nodeProperties.add(NodeProperty.of((String)predictedProbabilityProperty.orElseThrow(), (NodePropertyValues)nodePropertyValues));
        return nodeProperties;
    }
}

