/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.regression.configure;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.ml.pipeline.ExecutableNodePropertyStep;
import org.neo4j.gds.ml.pipeline.FeatureStep;
import org.neo4j.gds.ml.pipeline.NodePropertyStepFactory;
import org.neo4j.gds.ml.pipeline.PipelineCatalog;
import org.neo4j.gds.ml.pipeline.node.NodePipelineInfoResult;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeFeatureStep;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodePropertyTrainingPipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.regression.NodeRegressionTrainingPipeline;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeRegressionPipelineAddStepProcs
extends BaseProc {
    @Procedure(name="gds.alpha.pipeline.nodeRegression.addNodeProperty", mode=Mode.READ)
    @Description(value="Add a node property step to an existing node regression training pipeline.")
    public Stream<NodePipelineInfoResult> addNodeProperty(@Name(value="pipelineName") String pipelineName, @Name(value="procedureName") String taskName, @Name(value="procedureConfiguration") Map<String, Object> procedureConfig) {
        NodeRegressionTrainingPipeline pipeline = (NodeRegressionTrainingPipeline)PipelineCatalog.getTyped((String)this.username(), (String)pipelineName, NodeRegressionTrainingPipeline.class);
        pipeline.addNodePropertyStep((ExecutableNodePropertyStep)NodePropertyStepFactory.createNodePropertyStep((String)taskName, procedureConfig));
        return Stream.of(new NodePipelineInfoResult(pipelineName, (NodePropertyTrainingPipeline)pipeline));
    }

    @Procedure(name="gds.alpha.pipeline.nodeRegression.selectFeatures", mode=Mode.READ)
    @Description(value="Add one or several features to an existing node regression training pipeline.")
    public Stream<NodePipelineInfoResult> selectFeatures(@Name(value="pipelineName") String pipelineName, @Name(value="featureProperties") Object featureProperties) {
        NodeRegressionTrainingPipeline pipeline = (NodeRegressionTrainingPipeline)PipelineCatalog.getTyped((String)this.username(), (String)pipelineName, NodeRegressionTrainingPipeline.class);
        if (featureProperties instanceof String) {
            pipeline.addFeatureStep((FeatureStep)NodeFeatureStep.of((String)((String)featureProperties)));
        } else if (featureProperties instanceof List) {
            List propertiesList = (List)featureProperties;
            for (Object o : propertiesList) {
                if (!(o instanceof String)) {
                    throw new IllegalArgumentException("The list `featureProperties` is required to contain only strings.");
                }
                pipeline.addFeatureStep((FeatureStep)NodeFeatureStep.of((String)((String)o)));
            }
        } else {
            throw new IllegalArgumentException("The value of `featureProperties` is required to be a list of strings.");
        }
        return Stream.of(new NodePipelineInfoResult(pipelineName, (NodePropertyTrainingPipeline)pipeline));
    }
}

