/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.regression.predict;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.ml.pipeline.PipelineCompanion;
import org.neo4j.gds.ml.pipeline.node.regression.predict.NodeRegressionPipelineStreamSpec;
import org.neo4j.gds.ml.pipeline.node.regression.predict.StreamResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeRegressionPipelineStreamProc
extends BaseProc {
    @Context
    public ModelCatalog internalModelCatalog;

    @Procedure(name="gds.alpha.pipeline.nodeRegression.predict.stream", mode=Mode.READ)
    @Description(value="Predicts target node property using a previously trained `NodeRegression` model")
    public Stream<StreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration") Map<String, Object> configuration) {
        PipelineCompanion.preparePipelineConfig((Object)graphName, configuration);
        return (Stream)new ProcedureExecutor((AlgorithmSpec)new NodeRegressionPipelineStreamSpec(), this.executionContext()).compute(graphName, configuration);
    }

    public ExecutionContext executionContext() {
        return super.executionContext().withModelCatalog(this.internalModelCatalog);
    }
}

