/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.ml.pipeline.TrainingPipeline;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureStep;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionTrainingPipeline;

public class PipelineInfoResult {
    public final String name;
    public final List<Map<String, Object>> nodePropertySteps;
    public final List<Map<String, Object>> featureSteps;
    public final Map<String, Object> splitConfig;
    public final Map<String, Object> autoTuningConfig;
    public final Object parameterSpace;

    PipelineInfoResult(String pipelineName, LinkPredictionTrainingPipeline pipeline) {
        this.name = pipelineName;
        this.nodePropertySteps = pipeline.nodePropertySteps().stream().map(ToMapConvertible::toMap).collect(Collectors.toList());
        this.featureSteps = pipeline.featureSteps().stream().map(LinkFeatureStep::toMap).collect(Collectors.toList());
        this.splitConfig = pipeline.splitConfig().toMap();
        this.autoTuningConfig = pipeline.autoTuningConfig().toMap();
        this.parameterSpace = TrainingPipeline.toMapParameterSpace((Map)pipeline.trainingParameterSpace());
    }
}

