/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LPGraphStoreFilter;

@ParametersAreNonnullByDefault
@Generated(from="LPGraphStoreFilter", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableLPGraphStoreFilter
implements LPGraphStoreFilter {
    private final Collection<NodeLabel> sourceNodeLabels;
    private final Collection<NodeLabel> targetNodeLabels;
    private final Collection<RelationshipType> predictRelationshipTypes;
    private final Collection<NodeLabel> nodePropertyStepsBaseLabels;
    private final transient Collection<NodeLabel> predictNodeLabels;

    private ImmutableLPGraphStoreFilter(Collection<NodeLabel> sourceNodeLabels, Collection<NodeLabel> targetNodeLabels, Collection<RelationshipType> predictRelationshipTypes, Collection<NodeLabel> nodePropertyStepsBaseLabels) {
        this.sourceNodeLabels = Objects.requireNonNull(sourceNodeLabels, "sourceNodeLabels");
        this.targetNodeLabels = Objects.requireNonNull(targetNodeLabels, "targetNodeLabels");
        this.predictRelationshipTypes = Objects.requireNonNull(predictRelationshipTypes, "predictRelationshipTypes");
        this.nodePropertyStepsBaseLabels = Objects.requireNonNull(nodePropertyStepsBaseLabels, "nodePropertyStepsBaseLabels");
        this.predictNodeLabels = Objects.requireNonNull(LPGraphStoreFilter.super.predictNodeLabels(), "predictNodeLabels");
    }

    private ImmutableLPGraphStoreFilter(ImmutableLPGraphStoreFilter original, Collection<NodeLabel> sourceNodeLabels, Collection<NodeLabel> targetNodeLabels, Collection<RelationshipType> predictRelationshipTypes, Collection<NodeLabel> nodePropertyStepsBaseLabels) {
        this.sourceNodeLabels = sourceNodeLabels;
        this.targetNodeLabels = targetNodeLabels;
        this.predictRelationshipTypes = predictRelationshipTypes;
        this.nodePropertyStepsBaseLabels = nodePropertyStepsBaseLabels;
        this.predictNodeLabels = Objects.requireNonNull(LPGraphStoreFilter.super.predictNodeLabels(), "predictNodeLabels");
    }

    @Override
    public Collection<NodeLabel> sourceNodeLabels() {
        return this.sourceNodeLabels;
    }

    @Override
    public Collection<NodeLabel> targetNodeLabels() {
        return this.targetNodeLabels;
    }

    @Override
    public Collection<RelationshipType> predictRelationshipTypes() {
        return this.predictRelationshipTypes;
    }

    @Override
    public Collection<NodeLabel> nodePropertyStepsBaseLabels() {
        return this.nodePropertyStepsBaseLabels;
    }

    @Override
    public Collection<NodeLabel> predictNodeLabels() {
        return this.predictNodeLabels;
    }

    public final ImmutableLPGraphStoreFilter withSourceNodeLabels(Collection<NodeLabel> value) {
        if (this.sourceNodeLabels == value) {
            return this;
        }
        Collection<NodeLabel> newValue = Objects.requireNonNull(value, "sourceNodeLabels");
        return new ImmutableLPGraphStoreFilter(this, newValue, this.targetNodeLabels, this.predictRelationshipTypes, this.nodePropertyStepsBaseLabels);
    }

    public final ImmutableLPGraphStoreFilter withTargetNodeLabels(Collection<NodeLabel> value) {
        if (this.targetNodeLabels == value) {
            return this;
        }
        Collection<NodeLabel> newValue = Objects.requireNonNull(value, "targetNodeLabels");
        return new ImmutableLPGraphStoreFilter(this, this.sourceNodeLabels, newValue, this.predictRelationshipTypes, this.nodePropertyStepsBaseLabels);
    }

    public final ImmutableLPGraphStoreFilter withPredictRelationshipTypes(Collection<RelationshipType> value) {
        if (this.predictRelationshipTypes == value) {
            return this;
        }
        Collection<RelationshipType> newValue = Objects.requireNonNull(value, "predictRelationshipTypes");
        return new ImmutableLPGraphStoreFilter(this, this.sourceNodeLabels, this.targetNodeLabels, newValue, this.nodePropertyStepsBaseLabels);
    }

    public final ImmutableLPGraphStoreFilter withNodePropertyStepsBaseLabels(Collection<NodeLabel> value) {
        if (this.nodePropertyStepsBaseLabels == value) {
            return this;
        }
        Collection<NodeLabel> newValue = Objects.requireNonNull(value, "nodePropertyStepsBaseLabels");
        return new ImmutableLPGraphStoreFilter(this, this.sourceNodeLabels, this.targetNodeLabels, this.predictRelationshipTypes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLPGraphStoreFilter && this.equalTo(0, (ImmutableLPGraphStoreFilter)another);
    }

    private boolean equalTo(int synthetic, ImmutableLPGraphStoreFilter another) {
        return this.sourceNodeLabels.equals(another.sourceNodeLabels) && this.targetNodeLabels.equals(another.targetNodeLabels) && this.predictRelationshipTypes.equals(another.predictRelationshipTypes) && this.nodePropertyStepsBaseLabels.equals(another.nodePropertyStepsBaseLabels) && this.predictNodeLabels.equals(another.predictNodeLabels);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sourceNodeLabels.hashCode();
        h += (h << 5) + this.targetNodeLabels.hashCode();
        h += (h << 5) + this.predictRelationshipTypes.hashCode();
        h += (h << 5) + this.nodePropertyStepsBaseLabels.hashCode();
        h += (h << 5) + this.predictNodeLabels.hashCode();
        return h;
    }

    public String toString() {
        return "LPGraphStoreFilter{sourceNodeLabels=" + this.sourceNodeLabels + ", targetNodeLabels=" + this.targetNodeLabels + ", predictRelationshipTypes=" + this.predictRelationshipTypes + ", nodePropertyStepsBaseLabels=" + this.nodePropertyStepsBaseLabels + ", predictNodeLabels=" + this.predictNodeLabels + "}";
    }

    public static LPGraphStoreFilter of(Collection<NodeLabel> sourceNodeLabels, Collection<NodeLabel> targetNodeLabels, Collection<RelationshipType> predictRelationshipTypes, Collection<NodeLabel> nodePropertyStepsBaseLabels) {
        return new ImmutableLPGraphStoreFilter(sourceNodeLabels, targetNodeLabels, predictRelationshipTypes, nodePropertyStepsBaseLabels);
    }

    public static LPGraphStoreFilter copyOf(LPGraphStoreFilter instance) {
        if (instance instanceof ImmutableLPGraphStoreFilter) {
            return (ImmutableLPGraphStoreFilter)instance;
        }
        return ImmutableLPGraphStoreFilter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LPGraphStoreFilter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_NODE_LABELS = 1L;
        private static final long INIT_BIT_TARGET_NODE_LABELS = 2L;
        private static final long INIT_BIT_PREDICT_RELATIONSHIP_TYPES = 4L;
        private static final long INIT_BIT_NODE_PROPERTY_STEPS_BASE_LABELS = 8L;
        private long initBits = 15L;
        @Nullable
        private Collection<NodeLabel> sourceNodeLabels;
        @Nullable
        private Collection<NodeLabel> targetNodeLabels;
        @Nullable
        private Collection<RelationshipType> predictRelationshipTypes;
        @Nullable
        private Collection<NodeLabel> nodePropertyStepsBaseLabels;

        private Builder() {
        }

        public final Builder from(LPGraphStoreFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.sourceNodeLabels(instance.sourceNodeLabels());
            this.targetNodeLabels(instance.targetNodeLabels());
            this.predictRelationshipTypes(instance.predictRelationshipTypes());
            this.nodePropertyStepsBaseLabels(instance.nodePropertyStepsBaseLabels());
            return this;
        }

        public final Builder sourceNodeLabels(Collection<NodeLabel> sourceNodeLabels) {
            this.sourceNodeLabels = Objects.requireNonNull(sourceNodeLabels, "sourceNodeLabels");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder targetNodeLabels(Collection<NodeLabel> targetNodeLabels) {
            this.targetNodeLabels = Objects.requireNonNull(targetNodeLabels, "targetNodeLabels");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder predictRelationshipTypes(Collection<RelationshipType> predictRelationshipTypes) {
            this.predictRelationshipTypes = Objects.requireNonNull(predictRelationshipTypes, "predictRelationshipTypes");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder nodePropertyStepsBaseLabels(Collection<NodeLabel> nodePropertyStepsBaseLabels) {
            this.nodePropertyStepsBaseLabels = Objects.requireNonNull(nodePropertyStepsBaseLabels, "nodePropertyStepsBaseLabels");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Builder clear() {
            this.initBits = 15L;
            this.sourceNodeLabels = null;
            this.targetNodeLabels = null;
            this.predictRelationshipTypes = null;
            this.nodePropertyStepsBaseLabels = null;
            return this;
        }

        public LPGraphStoreFilter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLPGraphStoreFilter(null, this.sourceNodeLabels, this.targetNodeLabels, this.predictRelationshipTypes, this.nodePropertyStepsBaseLabels);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceNodeLabels");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetNodeLabels");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("predictRelationshipTypes");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("nodePropertyStepsBaseLabels");
            }
            return "Cannot build LPGraphStoreFilter, some of required attributes are not set " + attributes;
        }
    }
}

