/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPipelineStreamSpec;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.StreamResult;
import org.neo4j.gds.ml.pipeline.PipelineCompanion;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LinkPredictionPipelineStreamProc
extends BaseProc {
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.beta.pipeline.linkPrediction.predict.stream", mode=Mode.READ)
    @Description(value="Predicts relationships for all non-connected node pairs based on a previously trained LinkPrediction model.")
    public Stream<StreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        PipelineCompanion.preparePipelineConfig((Object)graphName, configuration);
        return (Stream)new ProcedureExecutor((AlgorithmSpec)new LinkPredictionPipelineStreamSpec(), this.executionContext()).compute(graphName, configuration);
    }

    @Procedure(name="gds.beta.pipeline.linkPrediction.predict.stream.estimate", mode=Mode.READ)
    @Description(value="Estimates memory for predicting relationships for all non-connected node pairs based on a previously trained LinkPrediction model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        PipelineCompanion.preparePipelineConfig((Object)graphNameOrConfiguration, algoConfiguration);
        return new MemoryEstimationExecutor((AlgorithmSpec)new LinkPredictionPipelineStreamSpec(), this.executionContext(), this.transactionContext()).computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    public ExecutionContext executionContext() {
        return super.executionContext().withModelCatalog(this.modelCatalog);
    }
}

