/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.train;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import org.neo4j.gds.VerifyThatModelCanBeStored;
import org.neo4j.gds.compat.GdsVersionInfoProvider;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.executor.validation.BeforeLoadValidation;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionTrainPipelineAlgorithmFactory;
import org.neo4j.gds.ml.linkmodels.pipeline.train.TrainResult;
import org.neo4j.gds.ml.models.Classifier;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionModelInfo;
import org.neo4j.gds.ml.pipeline.linkPipeline.train.LinkPredictionTrainConfig;
import org.neo4j.gds.ml.pipeline.linkPipeline.train.LinkPredictionTrainPipelineExecutor;
import org.neo4j.graphdb.GraphDatabaseService;

@GdsCallable(name="gds.beta.pipeline.linkPrediction.train", description="Trains a link prediction model based on a pipeline", executionMode=ExecutionMode.TRAIN)
public class LinkPredictionPipelineTrainSpec
implements AlgorithmSpec<LinkPredictionTrainPipelineExecutor, LinkPredictionTrainPipelineExecutor.LinkPredictionTrainPipelineResult, LinkPredictionTrainConfig, Stream<TrainResult>, LinkPredictionTrainPipelineAlgorithmFactory> {
    public String name() {
        return "LinkPredictionPipelineTrain";
    }

    public LinkPredictionTrainPipelineAlgorithmFactory algorithmFactory(ExecutionContext executionContext) {
        String gdsVersion = GdsVersionInfoProvider.GDS_VERSION_INFO.gdsVersion();
        return new LinkPredictionTrainPipelineAlgorithmFactory(executionContext, gdsVersion);
    }

    public NewConfigFunction<LinkPredictionTrainConfig> newConfigFunction() {
        return LinkPredictionTrainConfig::of;
    }

    public ComputationResultConsumer<LinkPredictionTrainPipelineExecutor, LinkPredictionTrainPipelineExecutor.LinkPredictionTrainPipelineResult, LinkPredictionTrainConfig, Stream<TrainResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> computationResult.result().map(result -> {
            Model model = result.model();
            ModelCatalog modelCatalog = executionContext.modelCatalog();
            assert (modelCatalog != null) : "ModelCatalog should have been set in the ExecutionContext by this point!!!";
            modelCatalog.set(model);
            if (((LinkPredictionTrainConfig)computationResult.config()).storeModelToDisk()) {
                try {
                    GraphDatabaseService databaseService = (GraphDatabaseService)executionContext.dependencyResolver().resolveDependency(GraphDatabaseService.class);
                    modelCatalog.checkLicenseBeforeStoreModel(databaseService, "Store a model");
                    Path modelDir = modelCatalog.getModelDirectory(databaseService);
                    modelCatalog.store(model.creator(), model.name(), modelDir);
                }
                catch (Exception e) {
                    executionContext.log().error("Failed to store model to disk after training.", new Object[]{e.getMessage()});
                    throw e;
                }
            }
            return Stream.of(new TrainResult((Model<Classifier.ClassifierData, LinkPredictionTrainConfig, LinkPredictionModelInfo>)model, result.trainingStatistics(), computationResult.computeMillis()));
        }).orElseGet(Stream::empty);
    }

    public ValidationConfiguration<LinkPredictionTrainConfig> validationConfig(final ExecutionContext executionContext) {
        return new ValidationConfiguration<LinkPredictionTrainConfig>(){

            public List<BeforeLoadValidation<LinkPredictionTrainConfig>> beforeLoadValidations() {
                ModelCatalog modelCatalog = executionContext.modelCatalog();
                assert (modelCatalog != null) : "ModelCatalog should have been set in the ExecutionContext by this point!!!";
                return List.of(new VerifyThatModelCanBeStored(modelCatalog, executionContext.username(), "LinkPrediction"));
            }
        };
    }
}

