/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.ml.pipeline.TrainingPipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodePropertyTrainingPipeline;

public class NodePipelineInfoResult {
    public final String name;
    public final List<Map<String, Object>> nodePropertySteps;
    public final List<String> featureProperties;
    public final Map<String, Object> splitConfig;
    public final Map<String, Object> autoTuningConfig;
    public final Object parameterSpace;

    public NodePipelineInfoResult(String pipelineName, NodePropertyTrainingPipeline pipeline) {
        this.name = pipelineName;
        this.nodePropertySteps = pipeline.nodePropertySteps().stream().map(ToMapConvertible::toMap).collect(Collectors.toList());
        this.featureProperties = pipeline.featureProperties();
        this.splitConfig = pipeline.splitConfig().toMap();
        this.autoTuningConfig = pipeline.autoTuningConfig().toMap();
        this.parameterSpace = TrainingPipeline.toMapParameterSpace((Map)pipeline.trainingParameterSpace());
    }
}

