/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.classification.predict;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.write.NodePropertyExporterBuilder;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.ml.pipeline.PipelineCompanion;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPipelineWriteSpec;
import org.neo4j.gds.ml.pipeline.node.classification.predict.WriteResult;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPipelineWriteProc
extends BaseProc {
    @Context
    public ModelCatalog internalModelCatalog;
    @Context
    public NodePropertyExporterBuilder nodePropertyExporterBuilder;

    @Procedure(name="gds.beta.pipeline.nodeClassification.predict.write", mode=Mode.WRITE)
    @Description(value="Predicts classes for all nodes based on a previously trained pipeline model")
    public Stream<WriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        PipelineCompanion.preparePipelineConfig((Object)graphName, configuration);
        return (Stream)new ProcedureExecutor((AlgorithmSpec)new NodeClassificationPipelineWriteSpec(), this.executionContext()).compute(graphName, configuration);
    }

    @Procedure(name="gds.beta.pipeline.nodeClassification.predict.write.estimate", mode=Mode.READ)
    @Description(value="Estimates memory for predicting classes for all nodes based on a previously trained pipeline model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        PipelineCompanion.preparePipelineConfig((Object)graphNameOrConfiguration, algoConfiguration);
        return new MemoryEstimationExecutor((AlgorithmSpec)new NodeClassificationPipelineWriteSpec(), this.executionContext(), this.transactionContext()).computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    public ExecutionContext executionContext() {
        return super.executionContext().withNodePropertyExporterBuilder(this.nodePropertyExporterBuilder).withModelCatalog(this.internalModelCatalog);
    }
}

