/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.kge;

import java.util.stream.BaseStream;
import java.util.stream.Stream;
import org.neo4j.gds.MutateComputationResultConsumer;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.ResultBuilderFunction;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.api.TerminationMonitor;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.concurrency.DefaultPool;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.loading.SingleTypeRelationships;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.ml.kge.KGEMutateResult;
import org.neo4j.gds.ml.kge.KGEPredictMutateConfig;
import org.neo4j.gds.ml.kge.KGEPredictResult;
import org.neo4j.gds.ml.kge.TopKMapComputer;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.similarity.nodesim.TopKMap;

class KGEMutateResultConsumer
extends MutateComputationResultConsumer<TopKMapComputer, KGEPredictResult, KGEPredictMutateConfig, KGEMutateResult> {
    KGEMutateResultConsumer(ResultBuilderFunction<TopKMapComputer, KGEPredictResult, KGEPredictMutateConfig, KGEMutateResult> resultBuilderFunction) {
        super(resultBuilderFunction);
    }

    protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, ComputationResult<TopKMapComputer, KGEPredictResult, KGEPredictMutateConfig> computationResult, ExecutionContext executionContext) {
        GraphStore graphStore = computationResult.graphStore();
        Graph graph = graphStore.getGraph(new RelationshipType[0]);
        KGEPredictMutateConfig config = (KGEPredictMutateConfig)computationResult.config();
        int concurrency = config.concurrency();
        RelationshipType mutateRelationshipType = RelationshipType.of((String)config.mutateRelationshipType());
        RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().aggregation(Aggregation.SINGLE).nodes((PartialIdMap)graph).relationshipType(mutateRelationshipType).orientation(Orientation.NATURAL).addPropertyConfig(GraphFactory.PropertyConfig.builder().propertyKey(config.mutateProperty()).build()).concurrency(concurrency).executorService(DefaultPool.INSTANCE).build();
        Stream similarityResultStream = computationResult.result().map(KGEPredictResult::topKMap).map(TopKMap::stream).orElseGet(Stream::empty);
        ParallelUtil.parallelStreamConsume((BaseStream)similarityResultStream, (int)concurrency, (TerminationFlag)TerminationFlag.wrap((TerminationMonitor)executionContext.terminationMonitor()), stream -> stream.forEach(similarityResult -> relationshipsBuilder.addFromInternal(graph.toRootNodeId(similarityResult.sourceNodeId()), graph.toRootNodeId(similarityResult.targetNodeId()), similarityResult.property())));
        SingleTypeRelationships relationships = relationshipsBuilder.build();
        computationResult.graphStore().addRelationshipType(relationships);
        resultBuilder.withRelationshipsWritten(relationships.topology().elementCount());
    }
}

