/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.kge;

import com.carrotsearch.hppc.BitSet;
import java.util.Optional;
import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.ml.kge.KGEPredictBaseConfig;
import org.neo4j.gds.ml.kge.TopKMapComputer;
import org.neo4j.gds.similarity.filtering.NodeFilter;

public class KGEPredictAlgorithmFactory<CONFIG extends KGEPredictBaseConfig>
extends GraphStoreAlgorithmFactory<TopKMapComputer, CONFIG> {
    public TopKMapComputer build(GraphStore graphStore, CONFIG configuration, ProgressTracker progressTracker) {
        BitSet sourceNodes = new BitSet(graphStore.nodeCount());
        BitSet targetNodes = new BitSet(graphStore.nodeCount());
        Graph graph = graphStore.getGraph(configuration.relationshipTypesFilter(), Optional.empty());
        NodeFilter sourceNodeFilter = configuration.sourceNodeFilter().toNodeFilter((IdMap)graph);
        NodeFilter targetNodeFilter = configuration.targetNodeFilter().toNodeFilter((IdMap)graph);
        graph.forEachNode(node -> {
            if (sourceNodeFilter.test(node)) {
                sourceNodes.set(node);
            }
            if (targetNodeFilter.test(node)) {
                targetNodes.set(node);
            }
            return true;
        });
        return new TopKMapComputer(graph, sourceNodes, targetNodes, configuration.nodeEmbeddingProperty(), configuration.relationshipTypeEmbedding(), configuration.scoringFunction(), configuration.topK(), configuration.concurrency(), progressTracker);
    }

    public String taskName() {
        return "KGEPredict";
    }
}

