/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.kge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.ml.kge.KGEPredictStreamConfig;
import org.neo4j.gds.ml.kge.ScoreFunction;
import org.neo4j.gds.similarity.filtering.NodeFilterSpec;
import org.neo4j.gds.similarity.filtering.NodeFilterSpecFactory;

public final class KGEPredictStreamConfigImpl
implements KGEPredictStreamConfig {
    private NodeFilterSpec sourceNodeFilter;
    private NodeFilterSpec targetNodeFilter;
    private List<String> relationshipTypes;
    private String nodeEmbeddingProperty;
    private List<Double> relationshipTypeEmbedding;
    private ScoreFunction scoringFunction;
    private int topK;
    private List<String> nodeLabels;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private boolean logProgress;
    private int concurrency;
    private JobId jobId;

    public KGEPredictStreamConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.sourceNodeFilter = (NodeFilterSpec)CypherMapAccess.failOnNull((String)"sourceNodeFilter", (Object)NodeFilterSpecFactory.create((Object)config.getChecked("sourceNodeFilter", (Object)KGEPredictStreamConfig.super.sourceNodeFilter(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.targetNodeFilter = (NodeFilterSpec)CypherMapAccess.failOnNull((String)"targetNodeFilter", (Object)NodeFilterSpecFactory.create((Object)config.getChecked("targetNodeFilter", (Object)KGEPredictStreamConfig.super.targetNodeFilter(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapAccess.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", KGEPredictStreamConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeEmbeddingProperty = (String)CypherMapAccess.failOnNull((String)"nodeEmbeddingProperty", (Object)config.requireString("nodeEmbeddingProperty"));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypeEmbedding = (List)CypherMapAccess.failOnNull((String)"relationshipTypeEmbedding", (Object)((List)config.requireChecked("relationshipTypeEmbedding", List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.scoringFunction = (ScoreFunction)((Object)CypherMapAccess.failOnNull((String)"scoringFunction", (Object)((Object)ScoreFunction.parse(config.requireChecked("scoringFunction", Object.class)))));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.topK = config.requireInt("topK");
            CypherMapAccess.validateIntegerRange((String)"topK", (int)this.topK, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapAccess.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)KGEPredictStreamConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapAccess.failOnNull((String)"username", config.getOptional("username", String.class).map(BaseConfig::trim));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", KGEPredictStreamConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.logProgress = config.getBool("logProgress", KGEPredictStreamConfig.super.logProgress());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", KGEPredictStreamConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapAccess.failOnNull((String)"jobId", (Object)JobId.parse((Object)config.getChecked("jobId", (Object)KGEPredictStreamConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public NodeFilterSpec sourceNodeFilter() {
        return this.sourceNodeFilter;
    }

    @Override
    public NodeFilterSpec targetNodeFilter() {
        return this.targetNodeFilter;
    }

    @Override
    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    @Override
    public String nodeEmbeddingProperty() {
        return this.nodeEmbeddingProperty;
    }

    @Override
    public List<Double> relationshipTypeEmbedding() {
        return this.relationshipTypeEmbedding;
    }

    @Override
    public ScoreFunction scoringFunction() {
        return this.scoringFunction;
    }

    @Override
    public int topK() {
        return this.topK;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ArrayList<IllegalArgumentException> errors_ = new ArrayList<IllegalArgumentException>();
        try {
            this.validateSourceNodeFilter(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateTargetNodeFilter(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateNodeLabels(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateRelationshipTypes(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        if (!errors_.isEmpty()) {
            if (errors_.size() == 1) {
                throw (IllegalArgumentException)errors_.get(0);
            }
            String combinedErrorMsg_ = errors_.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError_ = new IllegalArgumentException(combinedErrorMsg_);
            errors_.forEach(error_ -> combinedError_.addSuppressed((Throwable)error_));
            throw combinedError_;
        }
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public boolean logProgress() {
        return this.logProgress;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("sourceNodeFilter", "targetNodeFilter", "relationshipTypes", "nodeEmbeddingProperty", "relationshipTypeEmbedding", "scoringFunction", "topK", "nodeLabels", "username", "sudo", "logProgress", "concurrency", "jobId");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("sourceNodeFilter", NodeFilterSpecFactory.render((NodeFilterSpec)this.sourceNodeFilter()));
        map.put("targetNodeFilter", NodeFilterSpecFactory.render((NodeFilterSpec)this.targetNodeFilter()));
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeEmbeddingProperty", this.nodeEmbeddingProperty());
        map.put("relationshipTypeEmbedding", this.relationshipTypeEmbedding());
        map.put("scoringFunction", ScoreFunction.toString(this.scoringFunction()));
        map.put("topK", this.topK());
        map.put("nodeLabels", this.nodeLabels());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("logProgress", this.logProgress());
        map.put("concurrency", this.concurrency());
        map.put("jobId", JobId.asString((JobId)this.jobId()));
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public JobId jobId() {
        return this.jobId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(KGEPredictStreamConfig baseConfig) {
            Builder builder = new Builder();
            builder.sourceNodeFilter(baseConfig.sourceNodeFilter());
            builder.targetNodeFilter(baseConfig.targetNodeFilter());
            builder.relationshipTypes(baseConfig.relationshipTypes());
            builder.nodeEmbeddingProperty(baseConfig.nodeEmbeddingProperty());
            builder.relationshipTypeEmbedding(baseConfig.relationshipTypeEmbedding());
            builder.scoringFunction((Object)baseConfig.scoringFunction());
            builder.topK(baseConfig.topK());
            builder.nodeLabels(baseConfig.nodeLabels());
            builder.usernameOverride(baseConfig.usernameOverride());
            builder.sudo(baseConfig.sudo());
            builder.logProgress(baseConfig.logProgress());
            builder.concurrency(baseConfig.concurrency());
            builder.jobId(baseConfig.jobId());
            return builder;
        }

        public Builder sourceNodeFilter(Object sourceNodeFilter) {
            this.config.put("sourceNodeFilter", sourceNodeFilter);
            return this;
        }

        public Builder targetNodeFilter(Object targetNodeFilter) {
            this.config.put("targetNodeFilter", targetNodeFilter);
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeEmbeddingProperty(String nodeEmbeddingProperty) {
            this.config.put("nodeEmbeddingProperty", nodeEmbeddingProperty);
            return this;
        }

        public Builder relationshipTypeEmbedding(List<Double> relationshipTypeEmbedding) {
            this.config.put("relationshipTypeEmbedding", relationshipTypeEmbedding);
            return this;
        }

        public Builder scoringFunction(Object scoringFunction) {
            this.config.put("scoringFunction", scoringFunction);
            return this;
        }

        public Builder topK(int topK) {
            this.config.put("topK", topK);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder logProgress(boolean logProgress) {
            this.config.put("logProgress", logProgress);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public KGEPredictStreamConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new KGEPredictStreamConfigImpl((CypherMapAccess)config);
        }
    }
}

