/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.kge;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.neo4j.gds.utils.StringFormatting;

public enum ScoreFunction {
    TRANSE,
    DISTMULT;

    private static final List<String> VALUES;

    public static ScoreFunction parse(Object input) {
        if (input instanceof String) {
            String inputString = StringFormatting.toUpperCaseWithLocale((String)((String)input));
            if (VALUES.contains(inputString)) {
                return ScoreFunction.valueOf(inputString.toUpperCase(Locale.ENGLISH));
            }
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Score function `%s` is not supported. Must be one of: %s.", (Object[])new Object[]{inputString, VALUES}));
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Score function `%s` is not supported. Must be one of: %s.", (Object[])new Object[]{input, VALUES}));
    }

    public static String toString(ScoreFunction scoreFunction) {
        return scoreFunction.toString();
    }

    static {
        VALUES = Arrays.stream(ScoreFunction.values()).map(Enum::name).collect(Collectors.toList());
    }
}

