/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.kge.scorers;

import com.carrotsearch.hppc.DoubleArrayList;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.ml.kge.scorers.LinkScorer;

public class DoubleEuclideanDistanceLinkScorer
implements LinkScorer {
    NodePropertyValues embeddings;
    double[] relationshipTypeEmbedding;
    long currentSourceNode;
    double[] currentCandidateTarget;

    DoubleEuclideanDistanceLinkScorer(NodePropertyValues embeddings, DoubleArrayList relationshipTypeEmbedding) {
        this.embeddings = embeddings;
        this.relationshipTypeEmbedding = relationshipTypeEmbedding.toArray();
        this.currentCandidateTarget = new double[this.relationshipTypeEmbedding.length];
    }

    @Override
    public void init(long sourceNode) {
        this.currentSourceNode = sourceNode;
        double[] currentSource = this.embeddings.doubleArrayValue(this.currentSourceNode);
        for (int i = 0; i < this.relationshipTypeEmbedding.length; ++i) {
            this.currentCandidateTarget[i] = currentSource[i] + this.relationshipTypeEmbedding[i];
        }
    }

    @Override
    public double computeScore(long targetNode) {
        double res = 0.0;
        double[] targetVector = this.embeddings.doubleArrayValue(targetNode);
        for (int i = 0; i < this.currentCandidateTarget.length; ++i) {
            double elem = this.currentCandidateTarget[i] - targetVector[i];
            res += elem * elem;
        }
        return Math.sqrt(res);
    }

    @Override
    public void close() throws Exception {
    }
}

