/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.kge.scorers;

import com.carrotsearch.hppc.DoubleArrayList;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.ml.kge.ScoreFunction;
import org.neo4j.gds.ml.kge.scorers.DoubleDistMultLinkScorer;
import org.neo4j.gds.ml.kge.scorers.DoubleEuclideanDistanceLinkScorer;
import org.neo4j.gds.ml.kge.scorers.FloatDistMultLinkScorer;
import org.neo4j.gds.ml.kge.scorers.FloatEuclideanDistanceLinkScorer;
import org.neo4j.gds.ml.kge.scorers.LinkScorer;

public class LinkScorerFactory {
    public static LinkScorer create(ScoreFunction scoreFunction, NodePropertyValues embeddings, DoubleArrayList relationshipTypeEmbedding) {
        switch (scoreFunction) {
            case TRANSE: {
                if (embeddings.valueType() == ValueType.FLOAT_ARRAY) {
                    return new FloatEuclideanDistanceLinkScorer(embeddings, relationshipTypeEmbedding);
                }
                if (embeddings.valueType() == ValueType.DOUBLE_ARRAY) {
                    return new DoubleEuclideanDistanceLinkScorer(embeddings, relationshipTypeEmbedding);
                }
                throw new IllegalArgumentException("Unsupported embeddings value type:" + embeddings.valueType());
            }
            case DISTMULT: {
                if (embeddings.valueType() == ValueType.FLOAT_ARRAY) {
                    return new FloatDistMultLinkScorer(embeddings, relationshipTypeEmbedding);
                }
                if (embeddings.valueType() == ValueType.DOUBLE_ARRAY) {
                    return new DoubleDistMultLinkScorer(embeddings, relationshipTypeEmbedding);
                }
                throw new IllegalArgumentException("Unsupported embeddings value type:" + embeddings.valueType());
            }
        }
        throw new IllegalArgumentException("Unknown score function:" + scoreFunction);
    }
}

