/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.ml.linkmodels.LinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LPNodeFilter;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionSimilarityComputer;
import org.neo4j.gds.ml.models.Classifier;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureExtractor;

public abstract class LinkPrediction {
    static final int MIN_NODE_BATCH_SIZE = 10;
    private final Classifier classifier;
    private final LinkFeatureExtractor linkFeatureExtractor;
    protected final Graph graph;
    protected final LPNodeFilter sourceNodeFilter;
    protected final LPNodeFilter targetNodeFilter;
    protected final int concurrency;
    final ProgressTracker progressTracker;

    LinkPrediction(Classifier classifier, LinkFeatureExtractor linkFeatureExtractor, Graph graph, LPNodeFilter sourceNodeFilter, LPNodeFilter targetNodeFilter, int concurrency, ProgressTracker progressTracker) {
        this.classifier = classifier;
        this.linkFeatureExtractor = linkFeatureExtractor;
        this.graph = graph;
        this.sourceNodeFilter = sourceNodeFilter;
        this.targetNodeFilter = targetNodeFilter;
        this.concurrency = concurrency;
        this.progressTracker = progressTracker;
    }

    public LinkPredictionResult compute() {
        this.progressTracker.beginSubTask();
        LinkPredictionResult result = this.predict();
        this.progressTracker.endSubTask();
        return result;
    }

    private LinkPredictionResult predict() {
        LinkPredictionSimilarityComputer linkPredictionSimilarityComputer = new LinkPredictionSimilarityComputer(this.linkFeatureExtractor, this.classifier);
        return this.predictLinks(linkPredictionSimilarityComputer);
    }

    abstract LinkPredictionResult predictLinks(LinkPredictionSimilarityComputer var1);
}

