/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node;

import java.util.List;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.ml.models.BaseModelData;
import org.neo4j.gds.ml.pipeline.node.ImmutablePredictGraphFilter;
import org.neo4j.gds.ml.pipeline.node.NodePropertyPredictPipelineBaseConfig;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodePropertyPipelineBaseTrainConfig;

public final class NodePropertyPredictPipelineFilterUtil {
    private NodePropertyPredictPipelineFilterUtil() {
    }

    public static PredictGraphFilter generatePredictPipelineFilter(ModelCatalog modelCatalog, String modelName, String username, NodePropertyPredictPipelineBaseConfig basePredictConfig) {
        Model trainedModel = modelCatalog.get(username, modelName, BaseModelData.class, NodePropertyPipelineBaseTrainConfig.class, Model.CustomInfo.class);
        List combinedTargetNodeLabels = basePredictConfig.targetNodeLabels().isEmpty() ? ((NodePropertyPipelineBaseTrainConfig)trainedModel.trainConfig()).targetNodeLabels() : basePredictConfig.targetNodeLabels();
        List combinedRelationshipTypes = basePredictConfig.relationshipTypes().isEmpty() ? ((NodePropertyPipelineBaseTrainConfig)trainedModel.trainConfig()).relationshipTypes() : basePredictConfig.relationshipTypes();
        return ImmutablePredictGraphFilter.builder().nodeLabels(combinedTargetNodeLabels).relationshipTypes(combinedRelationshipTypes).build();
    }

    @ValueClass
    public static interface PredictGraphFilter {
        public List<String> nodeLabels();

        public List<String> relationshipTypes();
    }
}

