/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.classification;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.ConfigKeyValidation;
import org.neo4j.gds.ml.api.TrainingMethod;
import org.neo4j.gds.ml.models.automl.TunableTrainerConfig;
import org.neo4j.gds.ml.models.logisticregression.LogisticRegressionTrainConfig;
import org.neo4j.gds.ml.models.mlp.MLPClassifierTrainConfig;
import org.neo4j.gds.ml.models.randomforest.RandomForestClassifierTrainerConfig;
import org.neo4j.gds.ml.pipeline.PipelineCatalog;
import org.neo4j.gds.ml.pipeline.node.NodePipelineInfoResult;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodePropertyTrainingPipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.classification.NodeClassificationTrainingPipeline;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Internal;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPipelineAddTrainerMethodProcs
extends BaseProc {
    @Procedure(name="gds.beta.pipeline.nodeClassification.addLogisticRegression", mode=Mode.READ)
    @Description(value="Add a logistic regression configuration to the parameter space of the node classification train pipeline.")
    public Stream<NodePipelineInfoResult> addLogisticRegression(@Name(value="pipelineName") String pipelineName, @Name(value="config", defaultValue="{}") Map<String, Object> logisticRegressionClassifierConfig) {
        NodeClassificationTrainingPipeline pipeline = (NodeClassificationTrainingPipeline)PipelineCatalog.getTyped((String)this.username(), (String)pipelineName, NodeClassificationTrainingPipeline.class);
        Collection allowedKeys = LogisticRegressionTrainConfig.DEFAULT.configKeys();
        ConfigKeyValidation.requireOnlyKeysFrom((Collection)allowedKeys, logisticRegressionClassifierConfig.keySet());
        TunableTrainerConfig tunableTrainerConfig = TunableTrainerConfig.of(logisticRegressionClassifierConfig, (TrainingMethod)TrainingMethod.LogisticRegression);
        pipeline.addTrainerConfig(tunableTrainerConfig);
        return Stream.of(new NodePipelineInfoResult(pipelineName, (NodePropertyTrainingPipeline)pipeline));
    }

    @Procedure(name="gds.beta.pipeline.nodeClassification.addRandomForest", mode=Mode.READ)
    @Description(value="Add a random forest configuration to the parameter space of the node classification train pipeline.")
    public Stream<NodePipelineInfoResult> addRandomForest(@Name(value="pipelineName") String pipelineName, @Name(value="config") Map<String, Object> randomForestClassifierConfig) {
        NodeClassificationTrainingPipeline pipeline = (NodeClassificationTrainingPipeline)PipelineCatalog.getTyped((String)this.username(), (String)pipelineName, NodeClassificationTrainingPipeline.class);
        Collection allowedKeys = RandomForestClassifierTrainerConfig.DEFAULT.configKeys();
        ConfigKeyValidation.requireOnlyKeysFrom((Collection)allowedKeys, randomForestClassifierConfig.keySet());
        TunableTrainerConfig tunableTrainerConfig = TunableTrainerConfig.of(randomForestClassifierConfig, (TrainingMethod)TrainingMethod.RandomForestClassification);
        pipeline.addTrainerConfig(tunableTrainerConfig);
        return Stream.of(new NodePipelineInfoResult(pipelineName, (NodePropertyTrainingPipeline)pipeline));
    }

    @Procedure(name="gds.alpha.pipeline.nodeClassification.addRandomForest", mode=Mode.READ, deprecatedBy="gds.beta.pipeline.nodeClassification.addRandomForest")
    @Description(value="Add a random forest configuration to the parameter space of the node classification train pipeline.")
    @Internal
    @Deprecated(forRemoval=true)
    public Stream<NodePipelineInfoResult> addRandomForestAlpha(@Name(value="pipelineName") String pipelineName, @Name(value="config") Map<String, Object> randomForestClassifierConfig) {
        this.executionContext().log().warn("Procedure `gds.alpha.pipeline.nodeClassification.addRandomForest` has been deprecated, please use `gds.beta.pipeline.nodeClassification.addRandomForest`.");
        return this.addRandomForest(pipelineName, randomForestClassifierConfig);
    }

    @Procedure(name="gds.alpha.pipeline.nodeClassification.addMLP", mode=Mode.READ)
    @Description(value="Add a multilayer perceptron configuration to the parameter space of the node classification train pipeline.")
    public Stream<NodePipelineInfoResult> addMLP(@Name(value="pipelineName") String pipelineName, @Name(value="config", defaultValue="{}") Map<String, Object> mlpClassifierConfig) {
        NodeClassificationTrainingPipeline pipeline = (NodeClassificationTrainingPipeline)PipelineCatalog.getTyped((String)this.username(), (String)pipelineName, NodeClassificationTrainingPipeline.class);
        Collection allowedKeys = MLPClassifierTrainConfig.DEFAULT.configKeys();
        ConfigKeyValidation.requireOnlyKeysFrom((Collection)allowedKeys, mlpClassifierConfig.keySet());
        pipeline.addTrainerConfig(TunableTrainerConfig.of(mlpClassifierConfig, (TrainingMethod)TrainingMethod.MLPClassification));
        return Stream.of(new NodePipelineInfoResult(pipelineName, (NodePropertyTrainingPipeline)pipeline));
    }
}

