/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.classification.predict;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.GraphNameConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.ml.pipeline.node.NodePropertyPredictPipelineBaseConfig;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictPipelineBaseConfig;
import org.neo4j.gds.model.ModelConfig;

@ParametersAreNonnullByDefault
@Generated(from="NodeClassificationPredictPipelineBaseConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableNodeClassificationPredictPipelineBaseConfig
implements NodeClassificationPredictPipelineBaseConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final JobId jobId;
    private final String graphName;
    private final String modelName;
    private final String modelUser;
    private final boolean includePredictedProbabilities;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableNodeClassificationPredictPipelineBaseConfig(int concurrency, int minBatchSize, String graphName, String modelName, String modelUser, boolean includePredictedProbabilities) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.graphName = Objects.requireNonNull(graphName, "graphName");
        this.modelName = Objects.requireNonNull(modelName, "modelName");
        this.modelUser = Objects.requireNonNull(modelUser, "modelUser");
        this.includePredictedProbabilities = includePredictedProbabilities;
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.initShim = null;
    }

    private ImmutableNodeClassificationPredictPipelineBaseConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.graphName = builder.graphName;
        this.modelName = builder.modelName;
        this.modelUser = builder.modelUser;
        this.includePredictedProbabilities = builder.includePredictedProbabilities;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.initShim = null;
    }

    private ImmutableNodeClassificationPredictPipelineBaseConfig(@Nullable String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, int minBatchSize, JobId jobId, String graphName, String modelName, String modelUser, boolean includePredictedProbabilities) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.jobId(jobId);
        this.graphName = graphName;
        this.modelName = modelName;
        this.modelUser = modelUser;
        this.includePredictedProbabilities = includePredictedProbabilities;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return NodeClassificationPredictPipelineBaseConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return NodeClassificationPredictPipelineBaseConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return NodeClassificationPredictPipelineBaseConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return NodeClassificationPredictPipelineBaseConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return NodeClassificationPredictPipelineBaseConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return NodeClassificationPredictPipelineBaseConfig.super.minBatchSize();
    }

    private JobId jobIdInitialize() {
        return NodeClassificationPredictPipelineBaseConfig.super.jobId();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public String graphName() {
        return this.graphName;
    }

    public String modelName() {
        return this.modelName;
    }

    public String modelUser() {
        return this.modelUser;
    }

    @Override
    public boolean includePredictedProbabilities() {
        return this.includePredictedProbabilities;
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withUsernameOverride(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.graphName, this.modelName, this.modelUser, this.includePredictedProbabilities));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.graphName, this.modelName, this.modelUser, this.includePredictedProbabilities));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.graphName, this.modelName, this.modelUser, this.includePredictedProbabilities));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.graphName, this.modelName, this.modelUser, this.includePredictedProbabilities));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.minBatchSize, this.jobId, this.graphName, this.modelName, this.modelUser, this.includePredictedProbabilities));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.minBatchSize, this.jobId, this.graphName, this.modelName, this.modelUser, this.includePredictedProbabilities));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, value, this.jobId, this.graphName, this.modelName, this.modelUser, this.includePredictedProbabilities));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.graphName, this.modelName, this.modelUser, this.includePredictedProbabilities));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withGraphName(String value) {
        String newValue = Objects.requireNonNull(value, "graphName");
        if (this.graphName.equals(newValue)) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.modelName, this.modelUser, this.includePredictedProbabilities));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withModelName(String value) {
        String newValue = Objects.requireNonNull(value, "modelName");
        if (this.modelName.equals(newValue)) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.graphName, newValue, this.modelUser, this.includePredictedProbabilities));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withModelUser(String value) {
        String newValue = Objects.requireNonNull(value, "modelUser");
        if (this.modelUser.equals(newValue)) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.graphName, this.modelName, newValue, this.includePredictedProbabilities));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withIncludePredictedProbabilities(boolean value) {
        if (this.includePredictedProbabilities == value) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.graphName, this.modelName, this.modelUser, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeClassificationPredictPipelineBaseConfig && this.equalTo(0, (ImmutableNodeClassificationPredictPipelineBaseConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableNodeClassificationPredictPipelineBaseConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.jobId.equals((Object)another.jobId) && this.graphName.equals(another.graphName) && this.modelName.equals(another.modelName) && this.modelUser.equals(another.modelUser) && this.includePredictedProbabilities == another.includePredictedProbabilities;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.graphName.hashCode();
        h += (h << 5) + this.modelName.hashCode();
        h += (h << 5) + this.modelUser.hashCode();
        h += (h << 5) + Boolean.hashCode(this.includePredictedProbabilities);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("NodeClassificationPredictPipelineBaseConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 44) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("graphName=").append(this.graphName);
        builder.append(", ");
        builder.append("modelName=").append(this.modelName);
        builder.append(", ");
        builder.append("modelUser=").append(this.modelUser);
        builder.append(", ");
        builder.append("includePredictedProbabilities=").append(this.includePredictedProbabilities);
        return builder.append("}").toString();
    }

    public static NodeClassificationPredictPipelineBaseConfig of(int concurrency, int minBatchSize, String graphName, String modelName, String modelUser, boolean includePredictedProbabilities) {
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(concurrency, minBatchSize, graphName, modelName, modelUser, includePredictedProbabilities));
    }

    private static ImmutableNodeClassificationPredictPipelineBaseConfig validate(ImmutableNodeClassificationPredictPipelineBaseConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static NodeClassificationPredictPipelineBaseConfig copyOf(NodeClassificationPredictPipelineBaseConfig instance) {
        if (instance instanceof ImmutableNodeClassificationPredictPipelineBaseConfig) {
            return (ImmutableNodeClassificationPredictPipelineBaseConfig)instance;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NodeClassificationPredictPipelineBaseConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GRAPH_NAME = 1L;
        private static final long INIT_BIT_MODEL_NAME = 2L;
        private static final long INIT_BIT_MODEL_USER = 4L;
        private static final long INIT_BIT_INCLUDE_PREDICTED_PROBABILITIES = 8L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private long initBits = 15L;
        private long optBits;
        @Nullable
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        @Nullable
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        @Nullable
        private JobId jobId;
        @Nullable
        private String graphName;
        @Nullable
        private String modelName;
        @Nullable
        private String modelUser;
        private boolean includePredictedProbabilities;

        private Builder() {
        }

        public final Builder from(NodePropertyPredictPipelineBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ModelConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(NodeClassificationPredictPipelineBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GraphNameConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional usernameOverrideOptional;
            NodePropertyPredictPipelineBaseConfig instance;
            long bits = 0L;
            if (object instanceof NodePropertyPredictPipelineBaseConfig) {
                instance = (NodePropertyPredictPipelineBaseConfig)object;
                if ((bits & 1L) == 0L) {
                    this.minBatchSize(instance.minBatchSize());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.jobId(instance.jobId());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.graphName(instance.graphName());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.modelName(instance.modelName());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    usernameOverrideOptional = instance.usernameOverride();
                    if (usernameOverrideOptional.isPresent()) {
                        this.usernameOverride(usernameOverrideOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.logProgress(instance.logProgress());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.sudo(instance.sudo());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.modelUser(instance.modelUser());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.configKeys(instance.configKeys());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.concurrency(instance.concurrency());
                    bits |= 0x200L;
                }
            }
            if (object instanceof ModelConfig) {
                instance = (ModelConfig)object;
                if ((bits & 8L) == 0L) {
                    this.modelName(instance.modelName());
                    bits |= 8L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.logProgress(instance.logProgress());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.sudo(instance.sudo());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.modelUser(instance.modelUser());
                    bits |= 0x80L;
                }
                if ((bits & 0x10L) == 0L) {
                    usernameOverrideOptional = instance.usernameOverride();
                    if (usernameOverrideOptional.isPresent()) {
                        this.usernameOverride(usernameOverrideOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.configKeys(instance.configKeys());
                    bits |= 0x100L;
                }
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                if ((bits & 2L) == 0L) {
                    this.jobId(instance.jobId());
                    bits |= 2L;
                }
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                if ((bits & 1L) == 0L) {
                    this.minBatchSize(instance.minBatchSize());
                    bits |= 1L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.concurrency(instance.concurrency());
                    bits |= 0x200L;
                }
            }
            if (object instanceof NodeClassificationPredictPipelineBaseConfig) {
                instance = (NodeClassificationPredictPipelineBaseConfig)object;
                if ((bits & 1L) == 0L) {
                    this.minBatchSize(instance.minBatchSize());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.jobId(instance.jobId());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.graphName(instance.graphName());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.modelName(instance.modelName());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    usernameOverrideOptional = instance.usernameOverride();
                    if (usernameOverrideOptional.isPresent()) {
                        this.usernameOverride(usernameOverrideOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.logProgress(instance.logProgress());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.sudo(instance.sudo());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.modelUser(instance.modelUser());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.configKeys(instance.configKeys());
                    bits |= 0x100L;
                }
                this.includePredictedProbabilities(instance.includePredictedProbabilities());
                if ((bits & 0x200L) == 0L) {
                    this.concurrency(instance.concurrency());
                    bits |= 0x200L;
                }
            }
            if (object instanceof GraphNameConfig) {
                instance = (GraphNameConfig)object;
                if ((bits & 4L) == 0L) {
                    this.graphName(instance.graphName());
                    bits |= 4L;
                }
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                if ((bits & 0x20L) == 0L) {
                    this.logProgress(instance.logProgress());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.sudo(instance.sudo());
                    bits |= 0x40L;
                }
                if ((bits & 0x10L) == 0L) {
                    usernameOverrideOptional = instance.usernameOverride();
                    if (usernameOverrideOptional.isPresent()) {
                        this.usernameOverride(usernameOverrideOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.configKeys(instance.configKeys());
                    bits |= 0x100L;
                }
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                if ((bits & 1L) == 0L) {
                    this.minBatchSize(instance.minBatchSize());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.jobId(instance.jobId());
                    bits |= 2L;
                }
                if ((bits & 0x10L) == 0L) {
                    usernameOverrideOptional = instance.usernameOverride();
                    if (usernameOverrideOptional.isPresent()) {
                        this.usernameOverride(usernameOverrideOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.logProgress(instance.logProgress());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.sudo(instance.sudo());
                    bits |= 0x40L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.configKeys(instance.configKeys());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.concurrency(instance.concurrency());
                    bits |= 0x200L;
                }
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder graphName(String graphName) {
            this.graphName = Objects.requireNonNull(graphName, "graphName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder modelName(String modelName) {
            this.modelName = Objects.requireNonNull(modelName, "modelName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder modelUser(String modelUser) {
            this.modelUser = Objects.requireNonNull(modelUser, "modelUser");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder includePredictedProbabilities(boolean includePredictedProbabilities) {
            this.includePredictedProbabilities = includePredictedProbabilities;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Builder clear() {
            this.initBits = 15L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.jobId = null;
            this.graphName = null;
            this.modelName = null;
            this.modelUser = null;
            this.includePredictedProbabilities = false;
            return this;
        }

        public NodeClassificationPredictPipelineBaseConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("graphName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("modelName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("modelUser");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("includePredictedProbabilities");
            }
            return "Cannot build NodeClassificationPredictPipelineBaseConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="NodeClassificationPredictPipelineBaseConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte jobIdBuildStage = 0;
        private JobId jobId;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableNodeClassificationPredictPipelineBaseConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableNodeClassificationPredictPipelineBaseConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableNodeClassificationPredictPipelineBaseConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableNodeClassificationPredictPipelineBaseConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableNodeClassificationPredictPipelineBaseConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableNodeClassificationPredictPipelineBaseConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableNodeClassificationPredictPipelineBaseConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            return "Cannot build NodeClassificationPredictPipelineBaseConfig, attribute initializers form cycle " + attributes;
        }
    }
}

