/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.classification.predict;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.ml.pipeline.PipelineCompanion;
import org.neo4j.gds.ml.pipeline.node.PredictMutateResult;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPipelineMutateSpec;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPipelineMutateProc
extends BaseProc {
    @Context
    public ModelCatalog internalModelCatalog;

    @Procedure(name="gds.beta.pipeline.nodeClassification.predict.mutate", mode=Mode.READ)
    @Description(value="Predicts classes for all nodes based on a previously trained pipeline model")
    public Stream<PredictMutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        PipelineCompanion.preparePipelineConfig((Object)graphName, configuration);
        return (Stream)new ProcedureExecutor((AlgorithmSpec)new NodeClassificationPipelineMutateSpec(), this.executionContext()).compute(graphName, configuration);
    }

    @Procedure(name="gds.beta.pipeline.nodeClassification.predict.mutate.estimate", mode=Mode.READ)
    @Description(value="Estimates memory for predicting classes for all nodes based on a previously trained pipeline model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphName, @Name(value="configuration") Map<String, Object> configuration) {
        PipelineCompanion.preparePipelineConfig((Object)graphName, configuration);
        return new MemoryEstimationExecutor((AlgorithmSpec)new NodeClassificationPipelineMutateSpec(), this.executionContext(), this.transactionContext()).computeEstimate(graphName, configuration);
    }

    public ExecutionContext executionContext() {
        return super.executionContext().withModelCatalog(this.internalModelCatalog);
    }
}

