/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.classification.predict;

import java.util.Optional;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.collections.ha.HugeIntArray;
import org.neo4j.gds.collections.ha.HugeLongArray;
import org.neo4j.gds.collections.ha.HugeObjectArray;
import org.neo4j.gds.ml.core.subgraph.LocalIdMap;
import org.neo4j.gds.ml.nodeClassification.NodeClassificationPredict;
import org.neo4j.gds.ml.pipeline.node.classification.predict.ImmutableNodeClassificationPipelineResult;

@ValueClass
public interface NodeClassificationPipelineResult {
    public HugeLongArray predictedClasses();

    public Optional<HugeObjectArray<double[]>> predictedProbabilities();

    public static NodeClassificationPipelineResult of(NodeClassificationPredict.NodeClassificationResult nodeClassificationResult, LocalIdMap classIdMap) {
        HugeIntArray internalPredictions = nodeClassificationResult.predictedClasses();
        HugeLongArray predictions = HugeLongArray.newArray((long)internalPredictions.size());
        for (long i = 0L; i < nodeClassificationResult.predictedClasses().size(); ++i) {
            predictions.set(i, classIdMap.toOriginal(internalPredictions.get(i)));
        }
        return ImmutableNodeClassificationPipelineResult.of(predictions, nodeClassificationResult.predictedProbabilities());
    }
}

