/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.classification.predict;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictPipelineWriteConfig;
import org.neo4j.gds.model.ModelConfig;

public final class NodeClassificationPredictPipelineWriteConfigImpl
implements NodeClassificationPredictPipelineWriteConfig {
    private Optional<String> predictedProbabilityProperty;
    private List<String> targetNodeLabels;
    private List<String> relationshipTypes;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private boolean logProgress;
    private int concurrency;
    private JobId jobId;
    private String graphName;
    private String modelName;
    private String modelUser;
    private String writeProperty;
    private int writeConcurrency;
    private Optional<WriteConfig.ArrowConnectionInfo> arrowConnectionInfo;

    public NodeClassificationPredictPipelineWriteConfigImpl(@NotNull String modelUser, @NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.predictedProbabilityProperty = (Optional)CypherMapAccess.failOnNull((String)"predictedProbabilityProperty", (Object)config.getOptional("predictedProbabilityProperty", String.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.targetNodeLabels = (List)CypherMapAccess.failOnNull((String)"targetNodeLabels", (Object)((List)config.getChecked("targetNodeLabels", NodeClassificationPredictPipelineWriteConfig.super.targetNodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapAccess.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", NodeClassificationPredictPipelineWriteConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapAccess.failOnNull((String)"username", config.getOptional("username", String.class).map(BaseConfig::trim));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", NodeClassificationPredictPipelineWriteConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.logProgress = config.getBool("logProgress", NodeClassificationPredictPipelineWriteConfig.super.logProgress());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", NodeClassificationPredictPipelineWriteConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapAccess.failOnNull((String)"jobId", (Object)JobId.parse((Object)config.getChecked("jobId", (Object)NodeClassificationPredictPipelineWriteConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.graphName = (String)CypherMapAccess.failOnNull((String)"graphName", (Object)config.requireString("graphName"));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.modelName = (String)CypherMapAccess.failOnNull((String)"modelName", (Object)ModelConfig.validateName((String)config.requireString("modelName")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.modelUser = (String)CypherMapAccess.failOnNull((String)"modelUser", (Object)modelUser);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeProperty = (String)CypherMapAccess.failOnNull((String)"writeProperty", (Object)WritePropertyConfig.validatePropertyName((String)config.requireString("writeProperty")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeConcurrency = config.getInt("writeConcurrency", NodeClassificationPredictPipelineWriteConfig.super.writeConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.arrowConnectionInfo = (Optional)CypherMapAccess.failOnNull((String)"arrowConnectionInfo", config.getOptional("arrowConnectionInfo", Object.class).map(WriteConfig.ArrowConnectionInfo::parse));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateWritePropertiesDiffer();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateWriteConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public Optional<String> predictedProbabilityProperty() {
        return this.predictedProbabilityProperty;
    }

    @Override
    public List<String> targetNodeLabels() {
        return this.targetNodeLabels;
    }

    @Override
    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ArrayList<IllegalArgumentException> errors_ = new ArrayList<IllegalArgumentException>();
        try {
            this.validateNodeLabels(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateRelationshipTypes(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateGraphIsSuitableForWrite(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        if (!errors_.isEmpty()) {
            if (errors_.size() == 1) {
                throw (IllegalArgumentException)errors_.get(0);
            }
            String combinedErrorMsg_ = errors_.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError_ = new IllegalArgumentException(combinedErrorMsg_);
            errors_.forEach(error_ -> combinedError_.addSuppressed((Throwable)error_));
            throw combinedError_;
        }
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public boolean logProgress() {
        return this.logProgress;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("predictedProbabilityProperty", "targetNodeLabels", "relationshipTypes", "username", "sudo", "logProgress", "concurrency", "jobId", "graphName", "modelName", "writeProperty", "writeConcurrency", "arrowConnectionInfo");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.predictedProbabilityProperty().ifPresent(predictedProbabilityProperty -> map.put("predictedProbabilityProperty", predictedProbabilityProperty));
        map.put("targetNodeLabels", this.targetNodeLabels());
        map.put("relationshipTypes", this.relationshipTypes());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("logProgress", this.logProgress());
        map.put("concurrency", this.concurrency());
        map.put("jobId", JobId.asString((JobId)this.jobId()));
        map.put("graphName", this.graphName());
        map.put("modelName", this.modelName());
        map.put("writeProperty", this.writeProperty());
        map.put("writeConcurrency", this.writeConcurrency());
        this.arrowConnectionInfo().ifPresent(arrowConnectionInfo -> map.put("arrowConnectionInfo", WriteConfig.ArrowConnectionInfo.toMap((WriteConfig.ArrowConnectionInfo)arrowConnectionInfo)));
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public JobId jobId() {
        return this.jobId;
    }

    public String graphName() {
        return this.graphName;
    }

    public String modelName() {
        return this.modelName;
    }

    public String modelUser() {
        return this.modelUser;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }

    public Optional<WriteConfig.ArrowConnectionInfo> arrowConnectionInfo() {
        return this.arrowConnectionInfo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private String modelUser;

        public static Builder from(NodeClassificationPredictPipelineWriteConfig baseConfig) {
            Builder builder = new Builder();
            builder.predictedProbabilityProperty(baseConfig.predictedProbabilityProperty());
            builder.targetNodeLabels(baseConfig.targetNodeLabels());
            builder.relationshipTypes(baseConfig.relationshipTypes());
            builder.usernameOverride(baseConfig.usernameOverride());
            builder.sudo(baseConfig.sudo());
            builder.logProgress(baseConfig.logProgress());
            builder.concurrency(baseConfig.concurrency());
            builder.jobId(baseConfig.jobId());
            builder.graphName(baseConfig.graphName());
            builder.modelName(baseConfig.modelName());
            builder.modelUser(baseConfig.modelUser());
            builder.writeProperty(baseConfig.writeProperty());
            builder.writeConcurrency(baseConfig.writeConcurrency());
            builder.arrowConnectionInfo((Object)baseConfig.arrowConnectionInfo());
            return builder;
        }

        public Builder modelUser(String modelUser) {
            this.modelUser = modelUser;
            return this;
        }

        public Builder predictedProbabilityProperty(String predictedProbabilityProperty) {
            this.config.put("predictedProbabilityProperty", predictedProbabilityProperty);
            return this;
        }

        public Builder predictedProbabilityProperty(Optional<String> predictedProbabilityProperty) {
            predictedProbabilityProperty.ifPresent(actualpredictedProbabilityProperty -> this.config.put("predictedProbabilityProperty", actualpredictedProbabilityProperty));
            return this;
        }

        public Builder targetNodeLabels(List<String> targetNodeLabels) {
            this.config.put("targetNodeLabels", targetNodeLabels);
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder logProgress(boolean logProgress) {
            this.config.put("logProgress", logProgress);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public Builder graphName(String graphName) {
            this.config.put("graphName", graphName);
            return this;
        }

        public Builder modelName(String modelName) {
            this.config.put("modelName", modelName);
            return this;
        }

        public Builder writeProperty(String writeProperty) {
            this.config.put("writeProperty", writeProperty);
            return this;
        }

        public Builder writeConcurrency(int writeConcurrency) {
            this.config.put("writeConcurrency", writeConcurrency);
            return this;
        }

        public Builder arrowConnectionInfo(Object arrowConnectionInfo) {
            this.config.put("arrowConnectionInfo", arrowConnectionInfo);
            return this;
        }

        public Builder arrowConnectionInfo(Optional<Object> arrowConnectionInfo) {
            arrowConnectionInfo.ifPresent(actualarrowConnectionInfo -> this.config.put("arrowConnectionInfo", actualarrowConnectionInfo));
            return this;
        }

        public NodeClassificationPredictPipelineWriteConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new NodeClassificationPredictPipelineWriteConfigImpl(this.modelUser, (CypherMapAccess)config);
        }
    }
}

