/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.regression.predict;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.MutatePropertyComputationResultConsumer;
import org.neo4j.gds.api.properties.nodes.DoubleNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.EmptyDoubleNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValuesAdapter;
import org.neo4j.gds.collections.ha.HugeDoubleArray;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.ml.pipeline.node.PredictMutateResult;
import org.neo4j.gds.ml.pipeline.node.regression.predict.NodeRegressionPipelineCompanion;
import org.neo4j.gds.ml.pipeline.node.regression.predict.NodeRegressionPredictPipelineAlgorithmFactory;
import org.neo4j.gds.ml.pipeline.node.regression.predict.NodeRegressionPredictPipelineExecutor;
import org.neo4j.gds.ml.pipeline.node.regression.predict.NodeRegressionPredictPipelineMutateConfig;

@GdsCallable(name="gds.alpha.pipeline.nodeRegression.predict.mutate", description="Predicts target node property using a previously trained `NodeRegression` model", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class NodeRegressionPipelineMutateSpec
implements AlgorithmSpec<NodeRegressionPredictPipelineExecutor, HugeDoubleArray, NodeRegressionPredictPipelineMutateConfig, Stream<PredictMutateResult>, NodeRegressionPredictPipelineAlgorithmFactory<NodeRegressionPredictPipelineMutateConfig>> {
    public String name() {
        return "NodeRegressionPipelineMutate";
    }

    public NodeRegressionPredictPipelineAlgorithmFactory<NodeRegressionPredictPipelineMutateConfig> algorithmFactory(ExecutionContext executionContext) {
        return new NodeRegressionPredictPipelineAlgorithmFactory<NodeRegressionPredictPipelineMutateConfig>(executionContext);
    }

    public NewConfigFunction<NodeRegressionPredictPipelineMutateConfig> newConfigFunction() {
        return NodeRegressionPredictPipelineMutateConfig::of;
    }

    public void preProcessConfig(Map<String, Object> userInput, ExecutionContext executionContext) {
        NodeRegressionPipelineCompanion.enhanceUserInput(userInput, executionContext);
    }

    public ComputationResultConsumer<NodeRegressionPredictPipelineExecutor, HugeDoubleArray, NodeRegressionPredictPipelineMutateConfig, Stream<PredictMutateResult>> computationResultConsumer() {
        return new MutatePropertyComputationResultConsumer(this::nodePropertyList, this::resultBuilder);
    }

    private List<NodeProperty> nodePropertyList(ComputationResult<NodeRegressionPredictPipelineExecutor, HugeDoubleArray, NodeRegressionPredictPipelineMutateConfig> computationResult) {
        return List.of(NodeProperty.of((String)((NodeRegressionPredictPipelineMutateConfig)computationResult.config()).mutateProperty(), (NodePropertyValues)this.nodeProperties(computationResult)));
    }

    private NodePropertyValues nodeProperties(ComputationResult<NodeRegressionPredictPipelineExecutor, HugeDoubleArray, NodeRegressionPredictPipelineMutateConfig> computationResult) {
        return (NodePropertyValues)computationResult.result().map(NodePropertyValuesAdapter::adapt).orElse((DoubleNodePropertyValues)EmptyDoubleNodePropertyValues.INSTANCE);
    }

    private PredictMutateResult.Builder resultBuilder(ComputationResult<NodeRegressionPredictPipelineExecutor, HugeDoubleArray, NodeRegressionPredictPipelineMutateConfig> computeResult, ExecutionContext executionContext) {
        return new PredictMutateResult.Builder();
    }
}

