/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.regression.predict;

import java.util.Map;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.LoggingUtil;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.DoubleNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValuesAdapter;
import org.neo4j.gds.collections.ha.HugeDoubleArray;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.ml.pipeline.node.regression.predict.NodeRegressionPipelineCompanion;
import org.neo4j.gds.ml.pipeline.node.regression.predict.NodeRegressionPredictPipelineAlgorithmFactory;
import org.neo4j.gds.ml.pipeline.node.regression.predict.NodeRegressionPredictPipelineBaseConfig;
import org.neo4j.gds.ml.pipeline.node.regression.predict.NodeRegressionPredictPipelineExecutor;
import org.neo4j.gds.ml.pipeline.node.regression.predict.StreamResult;
import org.neo4j.logging.Log;

@GdsCallable(name="gds.alpha.pipeline.nodeRegression.predict.stream", description="Predicts target node property using a previously trained `NodeRegression` model", executionMode=ExecutionMode.STREAM)
public class NodeRegressionPipelineStreamSpec
implements AlgorithmSpec<NodeRegressionPredictPipelineExecutor, HugeDoubleArray, NodeRegressionPredictPipelineBaseConfig, Stream<StreamResult>, NodeRegressionPredictPipelineAlgorithmFactory<NodeRegressionPredictPipelineBaseConfig>> {
    public String name() {
        return "NodeRegressionPipelineStream";
    }

    public NodeRegressionPredictPipelineAlgorithmFactory<NodeRegressionPredictPipelineBaseConfig> algorithmFactory(ExecutionContext executionContext) {
        return new NodeRegressionPredictPipelineAlgorithmFactory<NodeRegressionPredictPipelineBaseConfig>(executionContext);
    }

    public NewConfigFunction<NodeRegressionPredictPipelineBaseConfig> newConfigFunction() {
        return NodeRegressionPredictPipelineBaseConfig::of;
    }

    public void preProcessConfig(Map<String, Object> userInput, ExecutionContext executionContext) {
        NodeRegressionPipelineCompanion.enhanceUserInput(userInput, executionContext);
    }

    public ComputationResultConsumer<NodeRegressionPredictPipelineExecutor, HugeDoubleArray, NodeRegressionPredictPipelineBaseConfig, Stream<StreamResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> (Stream)LoggingUtil.runWithExceptionLogging((String)"Result streaming failed", (Log)executionContext.log(), () -> computationResult.result().map(result -> {
            Graph graph = computationResult.graph();
            DoubleNodePropertyValues nodePropertyValues = NodePropertyValuesAdapter.adapt((HugeDoubleArray)result);
            return LongStream.range(0L, graph.nodeCount()).filter(arg_0 -> ((NodePropertyValues)nodePropertyValues).hasValue(arg_0)).mapToObj(arg_0 -> NodeRegressionPipelineStreamSpec.lambda$computationResultConsumer$0(graph, (NodePropertyValues)nodePropertyValues, arg_0));
        }).orElseGet(Stream::empty));
    }

    private static /* synthetic */ StreamResult lambda$computationResultConsumer$0(Graph graph, NodePropertyValues nodePropertyValues, long nodeId) {
        return new StreamResult(graph.toOriginalNodeId(nodeId), nodePropertyValues.doubleValue(nodeId));
    }
}

