/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.kge;

import java.util.Collection;
import java.util.List;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.ml.kge.KGEPredictParameters;
import org.neo4j.gds.ml.kge.ScoreFunction;
import org.neo4j.gds.similarity.filtering.NodeFilterSpec;

public interface KGEPredictBaseConfig
extends AlgoBaseConfig {
    @Configuration.ConvertWith(method="org.neo4j.gds.similarity.filtering.NodeFilterSpecFactory#create")
    @Configuration.ToMapValue(value="org.neo4j.gds.similarity.filtering.NodeFilterSpecFactory#render")
    default public NodeFilterSpec sourceNodeFilter() {
        return NodeFilterSpec.noOp;
    }

    @Configuration.ConvertWith(method="org.neo4j.gds.similarity.filtering.NodeFilterSpecFactory#create")
    @Configuration.ToMapValue(value="org.neo4j.gds.similarity.filtering.NodeFilterSpecFactory#render")
    default public NodeFilterSpec targetNodeFilter() {
        return NodeFilterSpec.noOp;
    }

    @Configuration.Key(value="relationshipTypes")
    default public List<String> relationshipTypes() {
        return List.of();
    }

    public String nodeEmbeddingProperty();

    public List<Double> relationshipTypeEmbedding();

    @Configuration.ConvertWith(method="org.neo4j.gds.ml.kge.ScoreFunction#parse")
    @Configuration.ToMapValue(value="org.neo4j.gds.ml.kge.ScoreFunction#toString")
    public ScoreFunction scoringFunction();

    @Configuration.IntegerRange(min=1)
    public int topK();

    @Configuration.GraphStoreValidationCheck
    default public void validateSourceNodeFilter(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        this.sourceNodeFilter().validate(graphStore, selectedLabels, "sourceNodeFilter");
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateTargetNodeFilter(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        this.targetNodeFilter().validate(graphStore, selectedLabels, "targetNodeFilter");
    }

    @Configuration.Ignore
    default public KGEPredictParameters toParameters() {
        return new KGEPredictParameters(this.concurrency(), this.sourceNodeFilter(), this.targetNodeFilter(), this.relationshipTypesFilter(), this.relationshipTypeEmbedding(), this.nodeEmbeddingProperty(), this.scoringFunction(), this.topK());
    }
}

