/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.kge;

import java.util.stream.Stream;
import org.neo4j.gds.ResultBuilderFunction;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.ml.kge.KGEMutateResult;
import org.neo4j.gds.ml.kge.KGEMutateResultConsumer;
import org.neo4j.gds.ml.kge.KGEPredictAlgorithmFactory;
import org.neo4j.gds.ml.kge.KGEPredictMutateConfig;
import org.neo4j.gds.ml.kge.KGEPredictResult;
import org.neo4j.gds.ml.kge.TopKMapComputer;
import org.neo4j.gds.procedures.algorithms.configuration.NewConfigFunction;

@GdsCallable(name="gds.ml.kge.predict.mutate", description="Predicts new relationships using an existing KGE model", executionMode=ExecutionMode.MUTATE_RELATIONSHIP)
public class KGEPredictMutateSpec
implements AlgorithmSpec<TopKMapComputer, KGEPredictResult, KGEPredictMutateConfig, Stream<KGEMutateResult>, KGEPredictAlgorithmFactory<KGEPredictMutateConfig>> {
    public String name() {
        return "KGEPredictMutate";
    }

    public KGEPredictAlgorithmFactory<KGEPredictMutateConfig> algorithmFactory(ExecutionContext executionContext) {
        return new KGEPredictAlgorithmFactory<KGEPredictMutateConfig>();
    }

    public NewConfigFunction<KGEPredictMutateConfig> newConfigFunction() {
        return (__, config) -> KGEPredictMutateConfig.of(config);
    }

    public ComputationResultConsumer<TopKMapComputer, KGEPredictResult, KGEPredictMutateConfig, Stream<KGEMutateResult>> computationResultConsumer() {
        return new KGEMutateResultConsumer((ResultBuilderFunction<TopKMapComputer, KGEPredictResult, KGEPredictMutateConfig, KGEMutateResult>)((ResultBuilderFunction)this::resultBuilder));
    }

    private KGEMutateResult.Builder resultBuilder(ComputationResult<TopKMapComputer, KGEPredictResult, KGEPredictMutateConfig> computeResult, ExecutionContext executionContext) {
        return new KGEMutateResult.Builder();
    }
}

