/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.kge;

import java.util.stream.Stream;
import org.neo4j.gds.LoggingUtil;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.logging.Log;
import org.neo4j.gds.ml.kge.KGEPredictAlgorithmFactory;
import org.neo4j.gds.ml.kge.KGEPredictResult;
import org.neo4j.gds.ml.kge.KGEPredictStreamConfig;
import org.neo4j.gds.ml.kge.KGEStreamResult;
import org.neo4j.gds.ml.kge.TopKMapComputer;
import org.neo4j.gds.procedures.algorithms.configuration.NewConfigFunction;

@GdsCallable(name="gds.ml.kge.predict.stream", description="Predicts new relationships using an existing KGE model", executionMode=ExecutionMode.STREAM)
public class KGEPredictStreamSpec
implements AlgorithmSpec<TopKMapComputer, KGEPredictResult, KGEPredictStreamConfig, Stream<KGEStreamResult>, KGEPredictAlgorithmFactory<KGEPredictStreamConfig>> {
    public String name() {
        return "KGEPredictStream";
    }

    public KGEPredictAlgorithmFactory<KGEPredictStreamConfig> algorithmFactory(ExecutionContext executionContext) {
        return new KGEPredictAlgorithmFactory<KGEPredictStreamConfig>();
    }

    public NewConfigFunction<KGEPredictStreamConfig> newConfigFunction() {
        return (__, config) -> KGEPredictStreamConfig.of(config);
    }

    public ComputationResultConsumer<TopKMapComputer, KGEPredictResult, KGEPredictStreamConfig, Stream<KGEStreamResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> (Stream)LoggingUtil.runWithExceptionLogging((String)"Result streaming failed", (Log)executionContext.log(), () -> computationResult.result().map(result -> {
            GraphStore graphStore = computationResult.graphStore();
            Graph graph = graphStore.getGraph(new RelationshipType[0]);
            return result.topKMap().stream((node1, node2, similarity) -> new KGEStreamResult(graph.toOriginalNodeId(node1), graph.toOriginalNodeId(node2), similarity));
        }).orElseGet(Stream::empty));
    }
}

