/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.kge;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.write.RelationshipExporterBuilder;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.ml.kge.KGEPredictWriteSpec;
import org.neo4j.gds.ml.kge.KGEWriteResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Internal;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class KGEPredictWriteProc
extends BaseProc {
    @Context
    public RelationshipExporterBuilder relationshipExporterBuilder;

    @Procedure(name="gds.ml.kge.predict.write", mode=Mode.WRITE)
    @Description(value="Predicts new relationships using an existing KGE model.")
    @Internal
    public Stream<KGEWriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return (Stream)new ProcedureExecutor((AlgorithmSpec)new KGEPredictWriteSpec(), this.executionContext()).compute(graphName, configuration);
    }

    public ExecutionContext executionContext() {
        return super.executionContext().withRelationshipExporterBuilder(this.relationshipExporterBuilder);
    }
}

