/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.ml.linkmodels.pipeline.PipelineInfoResult;
import org.neo4j.gds.ml.pipeline.PipelineCatalog;
import org.neo4j.gds.ml.pipeline.TrainingPipeline;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionTrainingPipeline;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LinkPredictionPipelineCreateProc
extends BaseProc {
    @Procedure(name="gds.beta.pipeline.linkPrediction.create", mode=Mode.READ)
    @Description(value="Creates a link prediction pipeline in the pipeline catalog.")
    public Stream<PipelineInfoResult> create(@Name(value="pipelineName") String input) {
        String pipelineName = StringIdentifierValidations.validateNoWhiteCharacter((String)input, (String)"pipelineName");
        LinkPredictionTrainingPipeline pipeline = new LinkPredictionTrainingPipeline();
        PipelineCatalog.set((String)this.username(), (String)pipelineName, (TrainingPipeline)pipeline);
        return Stream.of(new PipelineInfoResult(pipelineName, pipeline));
    }
}

