/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.DefaultPool;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.mem.MemoryEstimation;
import org.neo4j.gds.ml.linkmodels.LinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.PredictedLink;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.ApproximateLinkPredictionEstimateDefinition;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LPNodeFilter;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPrediction;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineBaseConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionSimilarityComputer;
import org.neo4j.gds.ml.models.Classifier;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureExtractor;
import org.neo4j.gds.similarity.knn.ImmutableKnnContext;
import org.neo4j.gds.similarity.knn.Knn;
import org.neo4j.gds.similarity.knn.KnnContext;
import org.neo4j.gds.similarity.knn.KnnParameters;
import org.neo4j.gds.similarity.knn.KnnResult;
import org.neo4j.gds.similarity.knn.NeighborFilterFactory;
import org.neo4j.gds.similarity.knn.metrics.SimilarityComputer;
import org.neo4j.gds.termination.TerminationFlag;

public class ApproximateLinkPrediction
extends LinkPrediction {
    private final KnnParameters knnParameters;
    private final TerminationFlag terminationFlag;

    public ApproximateLinkPrediction(Classifier classifier, LinkFeatureExtractor linkFeatureExtractor, Graph graph, LPNodeFilter sourceNodeFilter, LPNodeFilter targetNodeFilter, KnnParameters knnParameters, ProgressTracker progressTracker, TerminationFlag terminationFlag) {
        super(classifier, linkFeatureExtractor, graph, sourceNodeFilter, targetNodeFilter, knnParameters.concurrency(), progressTracker);
        this.knnParameters = knnParameters;
        this.terminationFlag = terminationFlag;
    }

    public static MemoryEstimation estimate(LinkPredictionPredictPipelineBaseConfig config) {
        return new ApproximateLinkPredictionEstimateDefinition(config).memoryEstimation();
    }

    @Override
    LinkPredictionResult predictLinks(LinkPredictionSimilarityComputer linkPredictionSimilarityComputer) {
        Knn knn = Knn.create((Graph)this.graph, (KnnParameters)this.knnParameters, (SimilarityComputer)linkPredictionSimilarityComputer, (NeighborFilterFactory)new LinkPredictionSimilarityComputer.LinkFilterFactory(this.graph, this.sourceNodeFilter, this.targetNodeFilter), (KnnContext)ImmutableKnnContext.of((ExecutorService)DefaultPool.INSTANCE, (ProgressTracker)this.progressTracker), (TerminationFlag)TerminationFlag.RUNNING_TRUE);
        knn.setTerminationFlag(this.terminationFlag);
        KnnResult knnResult = knn.compute();
        return new Result(knnResult);
    }

    static class Result
    implements LinkPredictionResult {
        private final KnnResult predictions;
        private final Map<String, Object> samplingStats;

        Result(KnnResult knnResult) {
            this.predictions = knnResult;
            this.samplingStats = Map.of("strategy", "approximate", "linksConsidered", knnResult.nodePairsConsidered(), "ranIterations", knnResult.ranIterations(), "didConverge", knnResult.didConverge());
        }

        public Stream<PredictedLink> stream() {
            return this.predictions.streamSimilarityResult().map(i -> PredictedLink.of((long)i.sourceNodeId(), (long)i.targetNodeId(), (double)i.similarity));
        }

        public Map<String, Object> samplingStats() {
            return this.samplingStats;
        }
    }
}

