/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import java.util.function.LongPredicate;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;

public interface LPNodeFilter
extends LongPredicate {
    public long validNodeCount();

    public static LPNodeFilter of(final Graph predictGraph, final IdMap idMap) {
        if (predictGraph.nodeCount() == idMap.nodeCount()) {
            return new LPNodeFilter(){

                @Override
                public long validNodeCount() {
                    return idMap.nodeCount();
                }

                @Override
                public boolean test(long value) {
                    return true;
                }
            };
        }
        return new LPNodeFilter(){

            @Override
            public long validNodeCount() {
                return idMap.nodeCount();
            }

            @Override
            public boolean test(long id) {
                return idMap.containsOriginalId(predictGraph.toOriginalNodeId(id));
            }
        };
    }
}

