/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import java.util.Collection;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import org.neo4j.gds.MutateComputationResultConsumer;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.ResultBuilderFunction;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.concurrency.Concurrency;
import org.neo4j.gds.core.concurrency.DefaultPool;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.loading.SingleTypeRelationships;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.ml.linkmodels.LinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineExecutor;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineMutateConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.MutateResult;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.termination.TerminationFlag;
import org.neo4j.gds.termination.TerminationMonitor;

class LinkPredictionPipelineMutateResultConsumer
extends MutateComputationResultConsumer<LinkPredictionPredictPipelineExecutor, LinkPredictionResult, LinkPredictionPredictPipelineMutateConfig, MutateResult> {
    LinkPredictionPipelineMutateResultConsumer(ResultBuilderFunction<LinkPredictionPredictPipelineExecutor, LinkPredictionResult, LinkPredictionPredictPipelineMutateConfig, MutateResult> resultBuilderFunction) {
        super(resultBuilderFunction);
    }

    protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, ComputationResult<LinkPredictionPredictPipelineExecutor, LinkPredictionResult, LinkPredictionPredictPipelineMutateConfig> computationResult, ExecutionContext executionContext) {
        GraphStore graphStore = computationResult.graphStore();
        Collection<NodeLabel> labelFilter = ((LinkPredictionPredictPipelineExecutor)computationResult.algorithm()).labelFilter().predictNodeLabels();
        Graph graph = graphStore.getGraph(labelFilter);
        LinkPredictionPredictPipelineMutateConfig config = (LinkPredictionPredictPipelineMutateConfig)computationResult.config();
        Concurrency concurrency = config.concurrency();
        RelationshipType mutateRelationshipType = RelationshipType.of((String)config.mutateRelationshipType());
        RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().aggregation(Aggregation.SINGLE).nodes((PartialIdMap)graph).relationshipType(mutateRelationshipType).orientation(Orientation.UNDIRECTED).addPropertyConfig(GraphFactory.PropertyConfig.of((String)config.mutateProperty())).concurrency(concurrency).executorService(DefaultPool.INSTANCE).build();
        MutateResult.Builder resultWithHistogramBuilder = (MutateResult.Builder)resultBuilder;
        Stream predictedLinkStream = computationResult.result().map(LinkPredictionResult::stream).orElseGet(Stream::empty);
        ParallelUtil.parallelStreamConsume((BaseStream)predictedLinkStream, (Concurrency)concurrency, (TerminationFlag)TerminationFlag.wrap((TerminationMonitor)executionContext.terminationMonitor()), stream -> stream.forEach(predictedLink -> {
            relationshipsBuilder.addFromInternal(graph.toRootNodeId(predictedLink.sourceId()), graph.toRootNodeId(predictedLink.targetId()), predictedLink.probability());
            resultWithHistogramBuilder.recordHistogramValue(predictedLink.probability());
        }));
        SingleTypeRelationships relationships = relationshipsBuilder.build();
        computationResult.graphStore().addRelationshipType(relationships);
        resultBuilder.withRelationshipsWritten(relationships.topology().elementCount());
    }
}

