/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import java.util.Collections;
import java.util.stream.Stream;
import org.neo4j.gds.ResultBuilderFunction;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.ml.linkmodels.LinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPipelineMutateResultConsumer;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineAlgorithmFactory;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineExecutor;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineMutateConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.MutateResult;
import org.neo4j.gds.procedures.algorithms.configuration.NewConfigFunction;

@GdsCallable(name="gds.beta.pipeline.linkPrediction.predict.mutate", description="Predicts relationships for all non-connected node pairs based on a previously trained LinkPrediction model.", executionMode=ExecutionMode.MUTATE_RELATIONSHIP)
public class LinkPredictionPipelineMutateSpec
implements AlgorithmSpec<LinkPredictionPredictPipelineExecutor, LinkPredictionResult, LinkPredictionPredictPipelineMutateConfig, Stream<MutateResult>, LinkPredictionPredictPipelineAlgorithmFactory<LinkPredictionPredictPipelineMutateConfig>> {
    public String name() {
        return "LinkPredictionPipelineMutate";
    }

    public LinkPredictionPredictPipelineAlgorithmFactory<LinkPredictionPredictPipelineMutateConfig> algorithmFactory(ExecutionContext executionContext) {
        return new LinkPredictionPredictPipelineAlgorithmFactory<LinkPredictionPredictPipelineMutateConfig>(executionContext);
    }

    public NewConfigFunction<LinkPredictionPredictPipelineMutateConfig> newConfigFunction() {
        return LinkPredictionPredictPipelineMutateConfig::of;
    }

    public ComputationResultConsumer<LinkPredictionPredictPipelineExecutor, LinkPredictionResult, LinkPredictionPredictPipelineMutateConfig, Stream<MutateResult>> computationResultConsumer() {
        return new LinkPredictionPipelineMutateResultConsumer((ResultBuilderFunction<LinkPredictionPredictPipelineExecutor, LinkPredictionResult, LinkPredictionPredictPipelineMutateConfig, MutateResult>)((ResultBuilderFunction)this::resultBuilder));
    }

    private MutateResult.Builder resultBuilder(ComputationResult<LinkPredictionPredictPipelineExecutor, LinkPredictionResult, LinkPredictionPredictPipelineMutateConfig> computeResult, ExecutionContext executionContext) {
        MutateResult.Builder builder = new MutateResult.Builder().withSamplingStats(computeResult.result().map(LinkPredictionResult::samplingStats).orElseGet(Collections::emptyMap));
        if (executionContext.returnColumns().contains("probabilityDistribution")) {
            builder.withHistogram();
        }
        return builder;
    }
}

