/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.MutateRelationshipConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Concurrency;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineMutateConfig;
import org.neo4j.gds.model.ModelConfig;

public final class LinkPredictionPredictPipelineMutateConfigImpl
implements LinkPredictionPredictPipelineMutateConfig {
    private String mutateProperty;
    private double sampleRate;
    private Optional<String> sourceNodeLabel;
    private Optional<String> targetNodeLabel;
    private List<String> relationshipTypes;
    private Optional<Integer> topN;
    private Optional<Double> threshold;
    private Optional<Integer> topK;
    private Optional<Double> deltaThreshold;
    private Optional<Integer> maxIterations;
    private Optional<Integer> randomJoins;
    private Optional<String> initialSampler;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private boolean logProgress;
    private Concurrency concurrency;
    private JobId jobId;
    private String graphName;
    private Optional<Long> randomSeed;
    private String modelName;
    private String modelUser;
    private String mutateRelationshipType;

    public LinkPredictionPredictPipelineMutateConfigImpl(@NotNull String modelUser, @NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.mutateProperty = (String)CypherMapAccess.failOnNull((String)"mutateProperty", (Object)config.getString("mutateProperty", LinkPredictionPredictPipelineMutateConfig.super.mutateProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sampleRate = config.getDouble("sampleRate", LinkPredictionPredictPipelineMutateConfig.super.sampleRate());
            CypherMapAccess.validateDoubleRange((String)"sampleRate", (double)this.sampleRate, (double)0.0, (double)1.0, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sourceNodeLabel = (Optional)CypherMapAccess.failOnNull((String)"sourceNodeLabel", (Object)config.getOptional("sourceNodeLabel", String.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.targetNodeLabel = (Optional)CypherMapAccess.failOnNull((String)"targetNodeLabel", (Object)config.getOptional("targetNodeLabel", String.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapAccess.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", LinkPredictionPredictPipelineMutateConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.topN = (Optional)CypherMapAccess.failOnNull((String)"topN", (Object)config.getOptional("topN", Integer.class));
            this.topN.ifPresent(topN -> CypherMapAccess.validateIntegerRange((String)"topN", (int)topN, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.threshold = (Optional)CypherMapAccess.failOnNull((String)"threshold", (Object)config.getOptional("threshold", Double.class));
            this.threshold.ifPresent(threshold -> CypherMapAccess.validateDoubleRange((String)"threshold", (double)threshold, (double)0.0, (double)1.0, (boolean)true, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.topK = (Optional)CypherMapAccess.failOnNull((String)"topK", (Object)config.getOptional("topK", Integer.class));
            this.topK.ifPresent(topK -> CypherMapAccess.validateIntegerRange((String)"topK", (int)topK, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.deltaThreshold = (Optional)CypherMapAccess.failOnNull((String)"deltaThreshold", (Object)config.getOptional("deltaThreshold", Double.class));
            this.deltaThreshold.ifPresent(deltaThreshold -> CypherMapAccess.validateDoubleRange((String)"deltaThreshold", (double)deltaThreshold, (double)0.0, (double)1.0, (boolean)true, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.maxIterations = (Optional)CypherMapAccess.failOnNull((String)"maxIterations", (Object)config.getOptional("maxIterations", Integer.class));
            this.maxIterations.ifPresent(maxIterations -> CypherMapAccess.validateIntegerRange((String)"maxIterations", (int)maxIterations, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomJoins = (Optional)CypherMapAccess.failOnNull((String)"randomJoins", (Object)config.getOptional("randomJoins", Integer.class));
            this.randomJoins.ifPresent(randomJoins -> CypherMapAccess.validateIntegerRange((String)"randomJoins", (int)randomJoins, (int)0, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.initialSampler = (Optional)CypherMapAccess.failOnNull((String)"initialSampler", (Object)config.getOptional("initialSampler", String.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapAccess.failOnNull((String)"username", config.getOptional("username", String.class).map(BaseConfig::trim));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", LinkPredictionPredictPipelineMutateConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.logProgress = config.getBool("logProgress", LinkPredictionPredictPipelineMutateConfig.super.logProgress());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = (Concurrency)CypherMapAccess.failOnNull((String)"concurrency", (Object)ConcurrencyConfig.parse((Object)config.getChecked("concurrency", (Object)LinkPredictionPredictPipelineMutateConfig.super.concurrency(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapAccess.failOnNull((String)"jobId", (Object)JobId.parse((Object)config.getChecked("jobId", (Object)LinkPredictionPredictPipelineMutateConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.graphName = (String)CypherMapAccess.failOnNull((String)"graphName", (Object)config.requireString("graphName"));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomSeed = (Optional)CypherMapAccess.failOnNull((String)"randomSeed", (Object)config.getOptional("randomSeed", Long.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.modelName = (String)CypherMapAccess.failOnNull((String)"modelName", (Object)ModelConfig.validateName((String)config.requireString("modelName")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.modelUser = (String)CypherMapAccess.failOnNull((String)"modelUser", (Object)modelUser);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.mutateRelationshipType = (String)CypherMapAccess.failOnNull((String)"mutateRelationshipType", (Object)MutateRelationshipConfig.validateMutateRelationshipTypeIdentifier((String)config.requireString("mutateRelationshipType")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateParameterCombinations();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validate();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public String mutateProperty() {
        return this.mutateProperty;
    }

    @Override
    public double sampleRate() {
        return this.sampleRate;
    }

    @Override
    public Optional<String> sourceNodeLabel() {
        return this.sourceNodeLabel;
    }

    @Override
    public Optional<String> targetNodeLabel() {
        return this.targetNodeLabel;
    }

    @Override
    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    @Override
    public Optional<Integer> topN() {
        return this.topN;
    }

    @Override
    public Optional<Double> threshold() {
        return this.threshold;
    }

    @Override
    public Optional<Integer> topK() {
        return this.topK;
    }

    @Override
    public Optional<Double> deltaThreshold() {
        return this.deltaThreshold;
    }

    @Override
    public Optional<Integer> maxIterations() {
        return this.maxIterations;
    }

    @Override
    public Optional<Integer> randomJoins() {
        return this.randomJoins;
    }

    @Override
    public Optional<String> initialSampler() {
        return this.initialSampler;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ArrayList<IllegalArgumentException> errors_ = new ArrayList<IllegalArgumentException>();
        try {
            this.validateSourceNodeLabel(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateTargetNodeLabel(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateRelationshipTypes(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateNodeLabels(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateMutateRelationships(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        if (!errors_.isEmpty()) {
            if (errors_.size() == 1) {
                throw (IllegalArgumentException)errors_.get(0);
            }
            String combinedErrorMsg_ = errors_.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError_ = new IllegalArgumentException(combinedErrorMsg_);
            errors_.forEach(error_ -> combinedError_.addSuppressed((Throwable)error_));
            throw combinedError_;
        }
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public boolean logProgress() {
        return this.logProgress;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("mutateProperty", "sampleRate", "sourceNodeLabel", "targetNodeLabel", "relationshipTypes", "topN", "threshold", "topK", "deltaThreshold", "maxIterations", "randomJoins", "initialSampler", "username", "sudo", "logProgress", "concurrency", "jobId", "graphName", "randomSeed", "modelName", "mutateRelationshipType");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("mutateProperty", this.mutateProperty());
        map.put("sampleRate", this.sampleRate());
        this.sourceNodeLabel().ifPresent(sourceNodeLabel -> map.put("sourceNodeLabel", sourceNodeLabel));
        this.targetNodeLabel().ifPresent(targetNodeLabel -> map.put("targetNodeLabel", targetNodeLabel));
        map.put("relationshipTypes", this.relationshipTypes());
        this.topN().ifPresent(topN -> map.put("topN", topN));
        this.threshold().ifPresent(threshold -> map.put("threshold", threshold));
        this.topK().ifPresent(topK -> map.put("topK", topK));
        this.deltaThreshold().ifPresent(deltaThreshold -> map.put("deltaThreshold", deltaThreshold));
        this.maxIterations().ifPresent(maxIterations -> map.put("maxIterations", maxIterations));
        this.randomJoins().ifPresent(randomJoins -> map.put("randomJoins", randomJoins));
        this.initialSampler().ifPresent(initialSampler -> map.put("initialSampler", initialSampler));
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("logProgress", this.logProgress());
        map.put("concurrency", ConcurrencyConfig.render((Concurrency)this.concurrency()));
        map.put("jobId", JobId.asString((JobId)this.jobId()));
        map.put("graphName", this.graphName());
        this.randomSeed().ifPresent(randomSeed -> map.put("randomSeed", randomSeed));
        map.put("modelName", this.modelName());
        map.put("mutateRelationshipType", this.mutateRelationshipType());
        return map;
    }

    public Concurrency concurrency() {
        return this.concurrency;
    }

    public JobId jobId() {
        return this.jobId;
    }

    public String graphName() {
        return this.graphName;
    }

    public Optional<Long> randomSeed() {
        return this.randomSeed;
    }

    public String modelName() {
        return this.modelName;
    }

    public String modelUser() {
        return this.modelUser;
    }

    public String mutateRelationshipType() {
        return this.mutateRelationshipType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private String modelUser;

        public static Builder from(LinkPredictionPredictPipelineMutateConfig baseConfig) {
            Builder builder = new Builder();
            builder.mutateProperty(baseConfig.mutateProperty());
            builder.sampleRate(baseConfig.sampleRate());
            builder.sourceNodeLabel(baseConfig.sourceNodeLabel());
            builder.targetNodeLabel(baseConfig.targetNodeLabel());
            builder.relationshipTypes(baseConfig.relationshipTypes());
            builder.topN(baseConfig.topN());
            builder.threshold(baseConfig.threshold());
            builder.topK(baseConfig.topK());
            builder.deltaThreshold(baseConfig.deltaThreshold());
            builder.maxIterations(baseConfig.maxIterations());
            builder.randomJoins(baseConfig.randomJoins());
            builder.initialSampler(baseConfig.initialSampler());
            builder.usernameOverride(baseConfig.usernameOverride());
            builder.sudo(baseConfig.sudo());
            builder.logProgress(baseConfig.logProgress());
            builder.concurrency(baseConfig.concurrency());
            builder.jobId(baseConfig.jobId());
            builder.graphName(baseConfig.graphName());
            builder.randomSeed(baseConfig.randomSeed());
            builder.modelName(baseConfig.modelName());
            builder.modelUser(baseConfig.modelUser());
            builder.mutateRelationshipType(baseConfig.mutateRelationshipType());
            return builder;
        }

        public Builder modelUser(String modelUser) {
            this.modelUser = modelUser;
            return this;
        }

        public Builder mutateProperty(String mutateProperty) {
            this.config.put("mutateProperty", mutateProperty);
            return this;
        }

        public Builder sampleRate(double sampleRate) {
            this.config.put("sampleRate", sampleRate);
            return this;
        }

        public Builder sourceNodeLabel(String sourceNodeLabel) {
            this.config.put("sourceNodeLabel", sourceNodeLabel);
            return this;
        }

        public Builder sourceNodeLabel(Optional<String> sourceNodeLabel) {
            sourceNodeLabel.ifPresent(actualsourceNodeLabel -> this.config.put("sourceNodeLabel", actualsourceNodeLabel));
            return this;
        }

        public Builder targetNodeLabel(String targetNodeLabel) {
            this.config.put("targetNodeLabel", targetNodeLabel);
            return this;
        }

        public Builder targetNodeLabel(Optional<String> targetNodeLabel) {
            targetNodeLabel.ifPresent(actualtargetNodeLabel -> this.config.put("targetNodeLabel", actualtargetNodeLabel));
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder topN(Integer topN) {
            this.config.put("topN", topN);
            return this;
        }

        public Builder topN(Optional<Integer> topN) {
            topN.ifPresent(actualtopN -> this.config.put("topN", actualtopN));
            return this;
        }

        public Builder threshold(Double threshold) {
            this.config.put("threshold", threshold);
            return this;
        }

        public Builder threshold(Optional<Double> threshold) {
            threshold.ifPresent(actualthreshold -> this.config.put("threshold", actualthreshold));
            return this;
        }

        public Builder topK(Integer topK) {
            this.config.put("topK", topK);
            return this;
        }

        public Builder topK(Optional<Integer> topK) {
            topK.ifPresent(actualtopK -> this.config.put("topK", actualtopK));
            return this;
        }

        public Builder deltaThreshold(Double deltaThreshold) {
            this.config.put("deltaThreshold", deltaThreshold);
            return this;
        }

        public Builder deltaThreshold(Optional<Double> deltaThreshold) {
            deltaThreshold.ifPresent(actualdeltaThreshold -> this.config.put("deltaThreshold", actualdeltaThreshold));
            return this;
        }

        public Builder maxIterations(Integer maxIterations) {
            this.config.put("maxIterations", maxIterations);
            return this;
        }

        public Builder maxIterations(Optional<Integer> maxIterations) {
            maxIterations.ifPresent(actualmaxIterations -> this.config.put("maxIterations", actualmaxIterations));
            return this;
        }

        public Builder randomJoins(Integer randomJoins) {
            this.config.put("randomJoins", randomJoins);
            return this;
        }

        public Builder randomJoins(Optional<Integer> randomJoins) {
            randomJoins.ifPresent(actualrandomJoins -> this.config.put("randomJoins", actualrandomJoins));
            return this;
        }

        public Builder initialSampler(String initialSampler) {
            this.config.put("initialSampler", initialSampler);
            return this;
        }

        public Builder initialSampler(Optional<String> initialSampler) {
            initialSampler.ifPresent(actualinitialSampler -> this.config.put("initialSampler", actualinitialSampler));
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder logProgress(boolean logProgress) {
            this.config.put("logProgress", logProgress);
            return this;
        }

        public Builder concurrency(Object concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public Builder graphName(String graphName) {
            this.config.put("graphName", graphName);
            return this;
        }

        public Builder randomSeed(Long randomSeed) {
            this.config.put("randomSeed", randomSeed);
            return this;
        }

        public Builder randomSeed(Optional<Long> randomSeed) {
            randomSeed.ifPresent(actualrandomSeed -> this.config.put("randomSeed", actualrandomSeed));
            return this;
        }

        public Builder modelName(String modelName) {
            this.config.put("modelName", modelName);
            return this;
        }

        public Builder mutateRelationshipType(String mutateRelationshipType) {
            this.config.put("mutateRelationshipType", mutateRelationshipType);
            return this;
        }

        public LinkPredictionPredictPipelineMutateConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new LinkPredictionPredictPipelineMutateConfigImpl(this.modelUser, (CypherMapAccess)config);
        }
    }
}

