/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import java.util.Map;
import org.HdrHistogram.ConcurrentDoubleHistogram;
import org.HdrHistogram.DoubleHistogram;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.procedures.algorithms.results.StandardMutateResult;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.result.HistogramUtils;

public final class MutateResult
extends StandardMutateResult {
    public final long relationshipsWritten;
    public final Map<String, Object> probabilityDistribution;
    public final Map<String, Object> samplingStats;

    private MutateResult(long preProcessingMillis, long computeMillis, long mutateMillis, long relationshipsWritten, Map<String, Object> configuration, Map<String, Object> probabilityDistribution, Map<String, Object> samplingStats) {
        super(preProcessingMillis, computeMillis, 0L, mutateMillis, configuration);
        this.relationshipsWritten = relationshipsWritten;
        this.probabilityDistribution = probabilityDistribution;
        this.samplingStats = samplingStats;
    }

    static class Builder
    extends AbstractResultBuilder<MutateResult> {
        private Map<String, Object> samplingStats = null;
        @Nullable
        private ConcurrentDoubleHistogram histogram = null;

        Builder() {
        }

        public MutateResult build() {
            return new MutateResult(this.preProcessingMillis, this.computeMillis, this.mutateMillis, this.relationshipsWritten, this.config.toMap(), this.histogram == null ? Map.of() : HistogramUtils.similaritySummary((DoubleHistogram)this.histogram), this.samplingStats);
        }

        Builder withHistogram() {
            if (this.histogram != null) {
                return this;
            }
            this.histogram = new ConcurrentDoubleHistogram(5);
            return this;
        }

        void recordHistogramValue(double value) {
            if (this.histogram == null) {
                return;
            }
            if (value >= 1.0E-6) {
                this.histogram.recordValue(value);
            } else {
                this.histogram.recordValue(1.0E-6);
            }
        }

        Builder withSamplingStats(Map<String, Object> samplingStats) {
            this.samplingStats = samplingStats;
            return this;
        }
    }
}

