/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.train;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.applications.algorithms.machinery.MemoryEstimateResult;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionPipelineTrainSpec;
import org.neo4j.gds.ml.linkmodels.pipeline.train.TrainResult;
import org.neo4j.gds.ml.pipeline.PipelineCompanion;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LinkPredictionPipelineTrainProc
extends BaseProc {
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.beta.pipeline.linkPrediction.train", mode=Mode.READ)
    @Description(value="Trains a link prediction model based on a pipeline")
    public Stream<TrainResult> train(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> config) {
        PipelineCompanion.preparePipelineConfig((Object)graphName, config);
        return (Stream)new ProcedureExecutor((AlgorithmSpec)new LinkPredictionPipelineTrainSpec(), this.executionContext()).compute(graphName, config);
    }

    @Procedure(name="gds.beta.pipeline.linkPrediction.train.estimate", mode=Mode.READ)
    @Description(value="Estimates memory for applying a linkPrediction model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        PipelineCompanion.preparePipelineConfig((Object)graphNameOrConfiguration, algoConfiguration);
        return new MemoryEstimationExecutor((AlgorithmSpec)new LinkPredictionPipelineTrainSpec(), this.executionContext(), this.transactionContext()).computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    public ExecutionContext executionContext() {
        return super.executionContext().withModelCatalog(this.modelCatalog);
    }
}

