/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.classification;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.ml.pipeline.FeatureStep;
import org.neo4j.gds.ml.pipeline.PipelineCatalog;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeFeatureStep;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodePropertyTrainingPipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.classification.NodeClassificationTrainingPipeline;
import org.neo4j.gds.procedures.GraphDataScienceProcedures;
import org.neo4j.gds.procedures.pipelines.NodePipelineInfoResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPipelineAddStepProcs
extends BaseProc {
    @Context
    public GraphDataScienceProcedures facade;

    public NodeClassificationPipelineAddStepProcs() {
    }

    NodeClassificationPipelineAddStepProcs(GraphDataScienceProcedures facade) {
        this.facade = facade;
    }

    public static NodePipelineInfoResult selectFeatures(String username, String pipelineName, Object nodeProperties) {
        NodeClassificationTrainingPipeline pipeline = (NodeClassificationTrainingPipeline)PipelineCatalog.getTyped((String)username, (String)pipelineName, NodeClassificationTrainingPipeline.class);
        if (nodeProperties instanceof String) {
            pipeline.addFeatureStep((FeatureStep)NodeFeatureStep.of((String)((String)nodeProperties)));
        } else if (nodeProperties instanceof List) {
            List propertiesList = (List)nodeProperties;
            for (Object o : propertiesList) {
                if (!(o instanceof String)) {
                    throw new IllegalArgumentException("The list `nodeProperties` is required to contain only strings.");
                }
                pipeline.addFeatureStep((FeatureStep)NodeFeatureStep.of((String)((String)o)));
            }
        } else {
            throw new IllegalArgumentException("The value of `nodeProperties` is required to be a list of strings.");
        }
        return new NodePipelineInfoResult(pipelineName, (NodePropertyTrainingPipeline)pipeline);
    }

    @Procedure(name="gds.beta.pipeline.nodeClassification.addNodeProperty", mode=Mode.READ)
    @Description(value="Add a node property step to an existing node classification training pipeline.")
    public Stream<NodePipelineInfoResult> addNodeProperty(@Name(value="pipelineName") String pipelineName, @Name(value="procedureName") String taskName, @Name(value="procedureConfiguration") Map<String, Object> procedureConfig) {
        return this.facade.pipelines().addNodeProperty(pipelineName, taskName, procedureConfig);
    }

    @Procedure(name="gds.beta.pipeline.nodeClassification.selectFeatures", mode=Mode.READ)
    @Description(value="Add one or several features to an existing node classification training pipeline.")
    public Stream<NodePipelineInfoResult> selectFeatures(@Name(value="pipelineName") String pipelineName, @Name(value="nodeProperties") Object nodeProperties) {
        return Stream.of(NodeClassificationPipelineAddStepProcs.selectFeatures(this.username(), pipelineName, nodeProperties));
    }
}

