/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.classification.predict;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.collections.ha.HugeLongArray;
import org.neo4j.gds.collections.ha.HugeObjectArray;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPipelineResult;

@Generated(from="NodeClassificationPipelineResult", generator="Immutables")
public final class ImmutableNodeClassificationPipelineResult
implements NodeClassificationPipelineResult {
    private final HugeLongArray predictedClasses;
    private final HugeObjectArray<double[]> predictedProbabilities;

    private ImmutableNodeClassificationPipelineResult(HugeLongArray predictedClasses, Optional<? extends HugeObjectArray<double[]>> predictedProbabilities) {
        this.predictedClasses = Objects.requireNonNull(predictedClasses, "predictedClasses");
        this.predictedProbabilities = predictedProbabilities.orElse(null);
    }

    private ImmutableNodeClassificationPipelineResult(HugeLongArray predictedClasses, HugeObjectArray<double[]> predictedProbabilities) {
        this.predictedClasses = Objects.requireNonNull(predictedClasses, "predictedClasses");
        this.predictedProbabilities = predictedProbabilities;
    }

    private ImmutableNodeClassificationPipelineResult(ImmutableNodeClassificationPipelineResult original, HugeLongArray predictedClasses, HugeObjectArray<double[]> predictedProbabilities) {
        this.predictedClasses = predictedClasses;
        this.predictedProbabilities = predictedProbabilities;
    }

    @Override
    public HugeLongArray predictedClasses() {
        return this.predictedClasses;
    }

    @Override
    public Optional<HugeObjectArray<double[]>> predictedProbabilities() {
        return Optional.ofNullable(this.predictedProbabilities);
    }

    public final ImmutableNodeClassificationPipelineResult withPredictedClasses(HugeLongArray value) {
        if (this.predictedClasses == value) {
            return this;
        }
        HugeLongArray newValue = Objects.requireNonNull(value, "predictedClasses");
        return new ImmutableNodeClassificationPipelineResult(this, newValue, this.predictedProbabilities);
    }

    public final ImmutableNodeClassificationPipelineResult withPredictedProbabilities(HugeObjectArray<double[]> value) {
        HugeObjectArray<double[]> newValue = value;
        if (this.predictedProbabilities == newValue) {
            return this;
        }
        return new ImmutableNodeClassificationPipelineResult(this, this.predictedClasses, newValue);
    }

    public final ImmutableNodeClassificationPipelineResult withPredictedProbabilities(Optional<? extends HugeObjectArray<double[]>> optional) {
        HugeObjectArray value = optional.orElse(null);
        if (this.predictedProbabilities == value) {
            return this;
        }
        return new ImmutableNodeClassificationPipelineResult(this, this.predictedClasses, (HugeObjectArray<double[]>)value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeClassificationPipelineResult && this.equalTo(0, (ImmutableNodeClassificationPipelineResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableNodeClassificationPipelineResult another) {
        return this.predictedClasses.equals(another.predictedClasses) && Objects.equals(this.predictedProbabilities, another.predictedProbabilities);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.predictedClasses.hashCode();
        h += (h << 5) + Objects.hashCode(this.predictedProbabilities);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("NodeClassificationPipelineResult{");
        builder.append("predictedClasses=").append(this.predictedClasses);
        if (this.predictedProbabilities != null) {
            builder.append(", ");
            builder.append("predictedProbabilities=").append(this.predictedProbabilities);
        }
        return builder.append("}").toString();
    }

    public static NodeClassificationPipelineResult of(HugeLongArray predictedClasses, Optional<? extends HugeObjectArray<double[]>> predictedProbabilities) {
        return new ImmutableNodeClassificationPipelineResult(predictedClasses, predictedProbabilities);
    }

    public static NodeClassificationPipelineResult of(HugeLongArray predictedClasses, HugeObjectArray<double[]> predictedProbabilities) {
        return new ImmutableNodeClassificationPipelineResult(predictedClasses, predictedProbabilities);
    }

    public static NodeClassificationPipelineResult copyOf(NodeClassificationPipelineResult instance) {
        if (instance instanceof ImmutableNodeClassificationPipelineResult) {
            return (ImmutableNodeClassificationPipelineResult)instance;
        }
        return ImmutableNodeClassificationPipelineResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NodeClassificationPipelineResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PREDICTED_CLASSES = 1L;
        private long initBits = 1L;
        private HugeLongArray predictedClasses;
        private HugeObjectArray<double[]> predictedProbabilities;

        private Builder() {
        }

        public final Builder from(NodeClassificationPipelineResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.predictedClasses(instance.predictedClasses());
            Optional<HugeObjectArray<double[]>> predictedProbabilitiesOptional = instance.predictedProbabilities();
            if (predictedProbabilitiesOptional.isPresent()) {
                this.predictedProbabilities(predictedProbabilitiesOptional);
            }
            return this;
        }

        public final Builder predictedClasses(HugeLongArray predictedClasses) {
            this.predictedClasses = Objects.requireNonNull(predictedClasses, "predictedClasses");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder predictedProbabilities(HugeObjectArray<double[]> predictedProbabilities) {
            this.predictedProbabilities = predictedProbabilities;
            return this;
        }

        public final Builder predictedProbabilities(Optional<? extends HugeObjectArray<double[]>> predictedProbabilities) {
            this.predictedProbabilities = predictedProbabilities.orElse(null);
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.predictedClasses = null;
            this.predictedProbabilities = null;
            return this;
        }

        public NodeClassificationPipelineResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeClassificationPipelineResult(null, this.predictedClasses, this.predictedProbabilities);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("predictedClasses");
            }
            return "Cannot build NodeClassificationPipelineResult, some of required attributes are not set " + attributes;
        }
    }
}

