/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.classification.predict;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.applications.algorithms.machinery.MemoryEstimateResult;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.ml.pipeline.PipelineCompanion;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPipelineTrainResult;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPipelineTrainSpec;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPipelineTrainProc
extends BaseProc {
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.beta.pipeline.nodeClassification.train", mode=Mode.READ)
    @Description(value="Trains a node classification model based on a pipeline")
    public Stream<NodeClassificationPipelineTrainResult> train(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        PipelineCompanion.preparePipelineConfig((Object)graphName, configuration);
        return (Stream)new ProcedureExecutor((AlgorithmSpec)new NodeClassificationPipelineTrainSpec(), this.executionContext()).compute(graphName, configuration);
    }

    @Procedure(name="gds.beta.pipeline.nodeClassification.train.estimate", mode=Mode.READ)
    @Description(value="Estimates memory for training a node classification model based on a pipeline")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        PipelineCompanion.preparePipelineConfig((Object)graphNameOrConfiguration, algoConfiguration);
        return new MemoryEstimationExecutor((AlgorithmSpec)new NodeClassificationPipelineTrainSpec(), this.executionContext(), this.transactionContext()).computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    public ExecutionContext executionContext() {
        return super.executionContext().withModelCatalog(this.modelCatalog);
    }
}

