/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.classification.predict;

import java.util.Optional;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.ml.pipeline.node.NodePropertyPredictPipelineFilterUtil;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictPipelineMutateConfig;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictPipelineMutateConfigImpl;
import org.neo4j.gds.procedures.algorithms.configuration.NewConfigFunction;

public class NodeClassificationPredictNewMutateConfigFn
implements NewConfigFunction<NodeClassificationPredictPipelineMutateConfig> {
    private final ModelCatalog modelCatalog;

    NodeClassificationPredictNewMutateConfigFn(ModelCatalog modelCatalog) {
        this.modelCatalog = modelCatalog;
    }

    public NodeClassificationPredictPipelineMutateConfig apply(String username, CypherMapWrapper config) {
        NodeClassificationPredictPipelineMutateConfig basePredictConfig = NodeClassificationPredictPipelineMutateConfig.of(username, config);
        Optional modelName = config.getString("modelName");
        if (modelName.isEmpty()) {
            return basePredictConfig;
        }
        NodePropertyPredictPipelineFilterUtil.PredictGraphFilter combinedFilter = NodePropertyPredictPipelineFilterUtil.generatePredictPipelineFilter(this.modelCatalog, (String)modelName.get(), username, basePredictConfig);
        return NodeClassificationPredictPipelineMutateConfigImpl.Builder.from(basePredictConfig).targetNodeLabels(combinedFilter.nodeLabels()).relationshipTypes(combinedFilter.relationshipTypes()).build();
    }
}

