/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.classification.predict;

import java.util.Optional;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.ml.pipeline.node.NodePropertyPredictPipelineFilterUtil;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictPipelineStreamConfig;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictPipelineStreamConfigImpl;
import org.neo4j.gds.procedures.algorithms.configuration.NewConfigFunction;

class NodeClassificationPredictNewStreamConfigFn
implements NewConfigFunction<NodeClassificationPredictPipelineStreamConfig> {
    private final ModelCatalog modelCatalog;

    NodeClassificationPredictNewStreamConfigFn(ModelCatalog modelCatalog) {
        this.modelCatalog = modelCatalog;
    }

    public NodeClassificationPredictPipelineStreamConfig apply(String username, CypherMapWrapper config) {
        NodeClassificationPredictPipelineStreamConfig basePredictConfig = NodeClassificationPredictPipelineStreamConfig.of(username, config);
        Optional modelName = config.getString("modelName");
        if (modelName.isEmpty()) {
            return basePredictConfig;
        }
        NodePropertyPredictPipelineFilterUtil.PredictGraphFilter combinedFilter = NodePropertyPredictPipelineFilterUtil.generatePredictPipelineFilter(this.modelCatalog, (String)modelName.get(), username, basePredictConfig);
        return NodeClassificationPredictPipelineStreamConfigImpl.Builder.from(basePredictConfig).targetNodeLabels(combinedFilter.nodeLabels()).relationshipTypes(combinedFilter.relationshipTypes()).build();
    }
}

