/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.classification.predict;

import java.util.Optional;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.ml.pipeline.node.NodePropertyPredictPipelineFilterUtil;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictPipelineWriteConfig;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictPipelineWriteConfigImpl;
import org.neo4j.gds.procedures.algorithms.configuration.NewConfigFunction;

public class NodeClassificationPredictNewWriteConfigFn
implements NewConfigFunction<NodeClassificationPredictPipelineWriteConfig> {
    private final ModelCatalog modelCatalog;

    NodeClassificationPredictNewWriteConfigFn(ModelCatalog modelCatalog) {
        this.modelCatalog = modelCatalog;
    }

    public NodeClassificationPredictPipelineWriteConfig apply(String username, CypherMapWrapper config) {
        NodeClassificationPredictPipelineWriteConfig basePredictConfig = NodeClassificationPredictPipelineWriteConfig.of(username, config);
        Optional modelName = config.getString("modelName");
        if (modelName.isEmpty()) {
            return basePredictConfig;
        }
        NodePropertyPredictPipelineFilterUtil.PredictGraphFilter combinedFilter = NodePropertyPredictPipelineFilterUtil.generatePredictPipelineFilter(this.modelCatalog, (String)modelName.get(), username, basePredictConfig);
        return NodeClassificationPredictPipelineWriteConfigImpl.Builder.from(basePredictConfig).targetNodeLabels(combinedFilter.nodeLabels()).relationshipTypes(combinedFilter.relationshipTypes()).build();
    }
}

