/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.classification.predict;

import java.util.Collection;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.MutateNodePropertyConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictPipelineMutateConfigImpl;
import org.neo4j.gds.ml.pipeline.node.classification.predict.NodeClassificationPredictPipelineMutateOrWriteConfig;
import org.neo4j.gds.utils.StringFormatting;

@Configuration
public interface NodeClassificationPredictPipelineMutateConfig
extends NodeClassificationPredictPipelineMutateOrWriteConfig,
MutateNodePropertyConfig {
    public static NodeClassificationPredictPipelineMutateConfig of(String username, CypherMapWrapper config) {
        return new NodeClassificationPredictPipelineMutateConfigImpl(username, (CypherMapAccess)config);
    }

    @Configuration.Check
    default public void validateMutatePropertiesDiffer() {
        this.predictedProbabilityProperty().ifPresent(predictedProbabilityProperty -> {
            if (this.mutateProperty().equals(predictedProbabilityProperty)) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Configuration parameters `%s` and `%s` must be different (both were `%s`)", (Object[])new Object[]{"mutateProperty", "predictedProbabilityProperty", predictedProbabilityProperty}));
            }
        });
    }

    @Configuration.GraphStoreValidationCheck
    default public void validatePredictedProbabilityPropertyDoesNotExist(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        this.predictedProbabilityProperty().ifPresent(predictedProbabilityProperty -> {
            if (graphStore.hasNodeProperty(selectedLabels, predictedProbabilityProperty)) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Node property `%s` already exists in the in-memory graph.", (Object[])new Object[]{predictedProbabilityProperty}));
            }
        });
    }
}

