/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.regression.configure;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.pipeline.PipelineCatalog;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodePropertyPredictionSplitConfig;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodePropertyTrainingPipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.regression.NodeRegressionTrainingPipeline;
import org.neo4j.gds.procedures.pipelines.NodePipelineInfoResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeRegressionPipelineConfigureSplitProc
extends BaseProc {
    @Procedure(name="gds.alpha.pipeline.nodeRegression.configureSplit", mode=Mode.READ)
    @Description(value="Configures the graph splitting of a node regression pipeline.")
    public Stream<NodePipelineInfoResult> configureSplit(@Name(value="pipelineName") String pipelineName, @Name(value="configuration") Map<String, Object> configMap) {
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configMap);
        NodePropertyPredictionSplitConfig config = NodePropertyPredictionSplitConfig.of((CypherMapWrapper)cypherConfig);
        cypherConfig.requireOnlyKeysFrom(config.configKeys());
        NodeRegressionTrainingPipeline pipeline = (NodeRegressionTrainingPipeline)PipelineCatalog.getTyped((String)this.username(), (String)pipelineName, NodeRegressionTrainingPipeline.class);
        pipeline.setSplitConfig(config);
        return Stream.of(new NodePipelineInfoResult(pipelineName, (NodePropertyTrainingPipeline)pipeline));
    }
}

