/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.regression.configure;

import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.ml.pipeline.PipelineCatalog;
import org.neo4j.gds.ml.pipeline.TrainingPipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodePropertyTrainingPipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.regression.NodeRegressionTrainingPipeline;
import org.neo4j.gds.procedures.pipelines.NodePipelineInfoResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeRegressionPipelineCreateProc
extends BaseProc {
    @Procedure(name="gds.alpha.pipeline.nodeRegression.create", mode=Mode.READ)
    @Description(value="Creates a node regression training pipeline in the pipeline catalog.")
    public Stream<NodePipelineInfoResult> create(@Name(value="pipelineName") String pipelineName) {
        StringIdentifierValidations.validateNoWhiteCharacter((String)pipelineName, (String)"pipelineName");
        NodeRegressionTrainingPipeline pipeline = new NodeRegressionTrainingPipeline();
        PipelineCatalog.set((String)this.username(), (String)pipelineName, (TrainingPipeline)pipeline);
        return Stream.of(new NodePipelineInfoResult(pipelineName, (NodePropertyTrainingPipeline)pipeline));
    }
}

