/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.procedures.integration;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.gds.ProcedureCallContextReturnColumns;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.api.ProcedureReturnColumns;
import org.neo4j.gds.api.User;
import org.neo4j.gds.applications.graphstorecatalog.CatalogBusinessFacade;
import org.neo4j.gds.applications.graphstorecatalog.CatalogConfigurationService;
import org.neo4j.gds.applications.graphstorecatalog.CypherProjectApplication;
import org.neo4j.gds.applications.graphstorecatalog.DefaultCatalogBusinessFacade;
import org.neo4j.gds.applications.graphstorecatalog.DropGraphApplication;
import org.neo4j.gds.applications.graphstorecatalog.DropNodePropertiesApplication;
import org.neo4j.gds.applications.graphstorecatalog.DropRelationshipsApplication;
import org.neo4j.gds.applications.graphstorecatalog.EstimateCommonNeighbourAwareRandomWalkApplication;
import org.neo4j.gds.applications.graphstorecatalog.GenerateGraphApplication;
import org.neo4j.gds.applications.graphstorecatalog.GraphMemoryUsageApplication;
import org.neo4j.gds.applications.graphstorecatalog.GraphNameValidationService;
import org.neo4j.gds.applications.graphstorecatalog.GraphProjectMemoryUsageService;
import org.neo4j.gds.applications.graphstorecatalog.GraphSamplingApplication;
import org.neo4j.gds.applications.graphstorecatalog.GraphStoreValidationService;
import org.neo4j.gds.applications.graphstorecatalog.ListGraphApplication;
import org.neo4j.gds.applications.graphstorecatalog.NativeProjectApplication;
import org.neo4j.gds.applications.graphstorecatalog.NodeLabelMutatorApplication;
import org.neo4j.gds.applications.graphstorecatalog.StreamNodePropertiesApplication;
import org.neo4j.gds.applications.graphstorecatalog.StreamRelationshipPropertiesApplication;
import org.neo4j.gds.applications.graphstorecatalog.StreamRelationshipsApplication;
import org.neo4j.gds.applications.graphstorecatalog.SubGraphProjectApplication;
import org.neo4j.gds.applications.graphstorecatalog.WriteNodeLabelApplication;
import org.neo4j.gds.applications.graphstorecatalog.WriteNodePropertiesApplication;
import org.neo4j.gds.applications.graphstorecatalog.WriteRelationshipPropertiesApplication;
import org.neo4j.gds.applications.graphstorecatalog.WriteRelationshipsApplication;
import org.neo4j.gds.core.loading.GraphStoreCatalogService;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogStore;
import org.neo4j.gds.core.write.ExportBuildersProvider;
import org.neo4j.gds.core.write.ExporterContext;
import org.neo4j.gds.core.write.NodeLabelExporterBuilder;
import org.neo4j.gds.core.write.NodePropertyExporterBuilder;
import org.neo4j.gds.core.write.RelationshipExporterBuilder;
import org.neo4j.gds.core.write.RelationshipPropertiesExporterBuilder;
import org.neo4j.gds.logging.Log;
import org.neo4j.gds.metrics.projections.ProjectionMetricsService;
import org.neo4j.gds.procedures.KernelTransactionAccessor;
import org.neo4j.gds.procedures.ProcedureTransactionAccessor;
import org.neo4j.gds.procedures.TaskRegistryFactoryService;
import org.neo4j.gds.procedures.TerminationFlagService;
import org.neo4j.gds.procedures.TransactionContextAccessor;
import org.neo4j.gds.procedures.catalog.CatalogFacade;
import org.neo4j.gds.procedures.integration.ExporterBuildersProviderService;
import org.neo4j.gds.services.DatabaseIdAccessor;
import org.neo4j.gds.services.UserAccessor;
import org.neo4j.gds.services.UserLogServices;
import org.neo4j.gds.termination.TerminationFlag;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class CatalogFacadeProvider {
    private final CatalogConfigurationService catalogConfigurationService;
    private final Log log;
    private final GraphNameValidationService graphNameValidationService;
    private final GraphStoreCatalogService graphStoreCatalogService;
    private final GraphStoreValidationService graphStoreValidationService;
    private final ProcedureTransactionAccessor procedureTransactionAccessor;
    private final DatabaseIdAccessor databaseIdAccessor;
    private final ExporterBuildersProviderService exporterBuildersProviderService;
    private final KernelTransactionAccessor kernelTransactionAccessor;
    private final TaskRegistryFactoryService taskRegistryFactoryService;
    private final TerminationFlagService terminationFlagService;
    private final TransactionContextAccessor transactionContextAccessor;
    private final UserLogServices userLogServices;
    private final UserAccessor userAccessor;
    private final CypherProjectApplication cypherProjectApplication;
    private final DropGraphApplication dropGraphApplication;
    private final DropNodePropertiesApplication dropNodePropertiesApplication;
    private final DropRelationshipsApplication dropRelationshipsApplication;
    private final EstimateCommonNeighbourAwareRandomWalkApplication estimateCommonNeighbourAwareRandomWalkApplication;
    private final GenerateGraphApplication generateGraphApplication;
    private final GraphMemoryUsageApplication graphMemoryUsageApplication;
    private final GraphSamplingApplication graphSamplingApplication;
    private final ListGraphApplication listGraphApplication;
    private final NativeProjectApplication nativeProjectApplication;
    private final NodeLabelMutatorApplication nodeLabelMutatorApplication;
    private final StreamNodePropertiesApplication streamNodePropertiesApplication;
    private final StreamRelationshipPropertiesApplication streamRelationshipPropertiesApplication;
    private final StreamRelationshipsApplication streamRelationshipsApplication;
    private final SubGraphProjectApplication subGraphProjectApplication;
    private final WriteNodeLabelApplication writeNodeLabelApplication;
    private final WriteNodePropertiesApplication writeNodePropertiesApplication;
    private final WriteRelationshipPropertiesApplication writeRelationshipPropertiesApplication;
    private final WriteRelationshipsApplication writeRelationshipsApplication;
    private final Optional<Function<CatalogBusinessFacade, CatalogBusinessFacade>> businessFacadeDecorator;
    private final ProjectionMetricsService projectionMetricsService;

    CatalogFacadeProvider(CatalogConfigurationService catalogConfigurationService, Log log, GraphNameValidationService graphNameValidationService, GraphStoreCatalogService graphStoreCatalogService, GraphStoreValidationService graphStoreValidationService, ProcedureTransactionAccessor procedureTransactionAccessor, DatabaseIdAccessor databaseIdAccessor, ExporterBuildersProviderService exporterBuildersProviderService, KernelTransactionAccessor kernelTransactionAccessor, TaskRegistryFactoryService taskRegistryFactoryService, TerminationFlagService terminationFlagService, TransactionContextAccessor transactionContextAccessor, UserLogServices userLogServices, UserAccessor userAccessor, CypherProjectApplication cypherProjectApplication, DropGraphApplication dropGraphApplication, DropNodePropertiesApplication dropNodePropertiesApplication, DropRelationshipsApplication dropRelationshipsApplication, EstimateCommonNeighbourAwareRandomWalkApplication estimateCommonNeighbourAwareRandomWalkApplication, GenerateGraphApplication generateGraphApplication, GraphMemoryUsageApplication graphMemoryUsageApplication, GraphSamplingApplication graphSamplingApplication, ListGraphApplication listGraphApplication, NativeProjectApplication nativeProjectApplication, NodeLabelMutatorApplication nodeLabelMutatorApplication, StreamNodePropertiesApplication streamNodePropertiesApplication, StreamRelationshipPropertiesApplication streamRelationshipPropertiesApplication, StreamRelationshipsApplication streamRelationshipsApplication, SubGraphProjectApplication subGraphProjectApplication, WriteNodeLabelApplication writeNodeLabelApplication, WriteNodePropertiesApplication writeNodePropertiesApplication, WriteRelationshipPropertiesApplication writeRelationshipPropertiesApplication, WriteRelationshipsApplication writeRelationshipsApplication, Optional<Function<CatalogBusinessFacade, CatalogBusinessFacade>> businessFacadeDecorator, ProjectionMetricsService projectionMetricsService) {
        this.catalogConfigurationService = catalogConfigurationService;
        this.graphNameValidationService = graphNameValidationService;
        this.graphStoreCatalogService = graphStoreCatalogService;
        this.graphStoreValidationService = graphStoreValidationService;
        this.log = log;
        this.procedureTransactionAccessor = procedureTransactionAccessor;
        this.databaseIdAccessor = databaseIdAccessor;
        this.exporterBuildersProviderService = exporterBuildersProviderService;
        this.kernelTransactionAccessor = kernelTransactionAccessor;
        this.taskRegistryFactoryService = taskRegistryFactoryService;
        this.terminationFlagService = terminationFlagService;
        this.transactionContextAccessor = transactionContextAccessor;
        this.userLogServices = userLogServices;
        this.userAccessor = userAccessor;
        this.cypherProjectApplication = cypherProjectApplication;
        this.dropGraphApplication = dropGraphApplication;
        this.dropNodePropertiesApplication = dropNodePropertiesApplication;
        this.dropRelationshipsApplication = dropRelationshipsApplication;
        this.estimateCommonNeighbourAwareRandomWalkApplication = estimateCommonNeighbourAwareRandomWalkApplication;
        this.generateGraphApplication = generateGraphApplication;
        this.graphMemoryUsageApplication = graphMemoryUsageApplication;
        this.graphSamplingApplication = graphSamplingApplication;
        this.listGraphApplication = listGraphApplication;
        this.nativeProjectApplication = nativeProjectApplication;
        this.nodeLabelMutatorApplication = nodeLabelMutatorApplication;
        this.streamNodePropertiesApplication = streamNodePropertiesApplication;
        this.streamRelationshipPropertiesApplication = streamRelationshipPropertiesApplication;
        this.streamRelationshipsApplication = streamRelationshipsApplication;
        this.subGraphProjectApplication = subGraphProjectApplication;
        this.writeNodeLabelApplication = writeNodeLabelApplication;
        this.writeNodePropertiesApplication = writeNodePropertiesApplication;
        this.writeRelationshipPropertiesApplication = writeRelationshipPropertiesApplication;
        this.writeRelationshipsApplication = writeRelationshipsApplication;
        this.businessFacadeDecorator = businessFacadeDecorator;
        this.projectionMetricsService = projectionMetricsService;
    }

    CatalogFacade createCatalogFacade(Context context) {
        GraphDatabaseAPI graphDatabaseService = context.graphDatabaseAPI();
        final KernelTransaction kernelTransaction = this.kernelTransactionAccessor.getKernelTransaction(context);
        Transaction procedureTransaction = this.procedureTransactionAccessor.getProcedureTransaction(context);
        DatabaseId databaseId = this.databaseIdAccessor.getDatabaseId((GraphDatabaseService)graphDatabaseService);
        GraphProjectMemoryUsageService graphProjectMemoryUsageService = new GraphProjectMemoryUsageService(this.log, (GraphDatabaseService)graphDatabaseService);
        ProcedureCallContextReturnColumns procedureReturnColumns = new ProcedureCallContextReturnColumns(context.procedureCallContext());
        Consumer<AutoCloseable> streamCloser = new Consumer<AutoCloseable>(){

            @Override
            public void accept(AutoCloseable autoCloseable) {
                try (Statement statement = kernelTransaction.acquireStatement();){
                    statement.registerCloseableResource(autoCloseable);
                }
            }
        };
        TerminationFlag terminationFlag = this.terminationFlagService.createTerminationFlag(kernelTransaction);
        TransactionContext transactionContext = this.transactionContextAccessor.transactionContext((GraphDatabaseService)graphDatabaseService, procedureTransaction);
        User user = this.userAccessor.getUser(context.securityContext());
        UserLogStore userLogStore = this.userLogServices.getUserLogStore(databaseId);
        TaskRegistryFactory taskRegistryFactory = this.taskRegistryFactoryService.getTaskRegistryFactory(databaseId, user);
        UserLogRegistryFactory userLogRegistryFactory = this.userLogServices.getUserLogRegistryFactory(databaseId, user);
        ExportBuildersProvider exportBuildersProvider = this.exporterBuildersProviderService.identifyExportBuildersProvider((GraphDatabaseService)graphDatabaseService);
        ExporterContext.ProcedureContextWrapper exporterContext = new ExporterContext.ProcedureContextWrapper(context);
        NodeLabelExporterBuilder nodeLabelExporterBuilder = exportBuildersProvider.nodeLabelExporterBuilder((ExporterContext)exporterContext);
        NodePropertyExporterBuilder nodePropertyExporterBuilder = exportBuildersProvider.nodePropertyExporterBuilder((ExporterContext)exporterContext);
        RelationshipExporterBuilder relationshipExporterBuilder = exportBuildersProvider.relationshipExporterBuilder((ExporterContext)exporterContext);
        RelationshipPropertiesExporterBuilder relationshipPropertiesExporterBuilder = exportBuildersProvider.relationshipPropertiesExporterBuilder((ExporterContext)exporterContext);
        DefaultCatalogBusinessFacade businessFacade = new DefaultCatalogBusinessFacade(this.log, this.catalogConfigurationService, this.graphNameValidationService, this.graphStoreCatalogService, this.graphStoreValidationService, this.cypherProjectApplication, this.dropGraphApplication, this.dropNodePropertiesApplication, this.dropRelationshipsApplication, this.estimateCommonNeighbourAwareRandomWalkApplication, this.generateGraphApplication, this.graphMemoryUsageApplication, this.graphSamplingApplication, this.listGraphApplication, this.nativeProjectApplication, this.nodeLabelMutatorApplication, this.streamNodePropertiesApplication, this.streamRelationshipPropertiesApplication, this.streamRelationshipsApplication, this.subGraphProjectApplication, this.writeNodePropertiesApplication, this.writeRelationshipPropertiesApplication, this.writeNodeLabelApplication, this.writeRelationshipsApplication, this.projectionMetricsService);
        if (this.businessFacadeDecorator.isPresent()) {
            businessFacade = this.businessFacadeDecorator.get().apply((CatalogBusinessFacade)businessFacade);
        }
        return new CatalogFacade((Consumer)streamCloser, databaseId, (GraphDatabaseService)graphDatabaseService, graphProjectMemoryUsageService, nodeLabelExporterBuilder, nodePropertyExporterBuilder, (ProcedureReturnColumns)procedureReturnColumns, relationshipExporterBuilder, relationshipPropertiesExporterBuilder, taskRegistryFactory, terminationFlag, transactionContext, user, userLogRegistryFactory, userLogStore, (CatalogBusinessFacade)businessFacade);
    }
}

