/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.procedures.integration;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.gds.applications.algorithms.pathfinding.AlgorithmProcessingTemplate;
import org.neo4j.gds.applications.graphstorecatalog.CatalogBusinessFacade;
import org.neo4j.gds.configuration.DefaultsConfiguration;
import org.neo4j.gds.configuration.LimitsConfiguration;
import org.neo4j.gds.core.loading.GraphStoreCatalogService;
import org.neo4j.gds.core.utils.mem.GcListenerExtension;
import org.neo4j.gds.core.utils.progress.ProgressFeatureSettings;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.progress.TaskStore;
import org.neo4j.gds.core.utils.progress.TaskStoreService;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.logging.Log;
import org.neo4j.gds.mem.MemoryGauge;
import org.neo4j.gds.metrics.MetricsFacade;
import org.neo4j.gds.metrics.algorithms.AlgorithmMetricsService;
import org.neo4j.gds.metrics.projections.ProjectionMetricsService;
import org.neo4j.gds.modelcatalogservices.ModelCatalogServiceProvider;
import org.neo4j.gds.procedures.GraphDataScience;
import org.neo4j.gds.procedures.KernelTransactionAccessor;
import org.neo4j.gds.procedures.TaskRegistryFactoryService;
import org.neo4j.gds.procedures.TerminationFlagService;
import org.neo4j.gds.procedures.configparser.ConfigurationParser;
import org.neo4j.gds.procedures.integration.AlgorithmFacadeProviderFactory;
import org.neo4j.gds.procedures.integration.AlgorithmMetaDataSetterService;
import org.neo4j.gds.procedures.integration.CatalogFacadeProvider;
import org.neo4j.gds.procedures.integration.CatalogFacadeProviderFactory;
import org.neo4j.gds.procedures.integration.ExporterBuildersProviderService;
import org.neo4j.gds.procedures.integration.GcListenerInstaller;
import org.neo4j.gds.procedures.integration.GraphDataScienceProvider;
import org.neo4j.gds.procedures.integration.TaskRegistryFactoryProvider;
import org.neo4j.gds.procedures.integration.TaskStoreProvider;
import org.neo4j.gds.procedures.integration.UserLogRegistryFactoryProvider;
import org.neo4j.gds.services.DatabaseIdAccessor;
import org.neo4j.gds.services.UserAccessor;
import org.neo4j.gds.services.UserLogServices;
import org.neo4j.gds.settings.GdsSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;

public final class ExtensionBuilder {
    private final AlgorithmMetaDataSetterService algorithmMetaDataSetterService = new AlgorithmMetaDataSetterService();
    private final DatabaseIdAccessor databaseIdAccessor = new DatabaseIdAccessor();
    private final KernelTransactionAccessor kernelTransactionAccessor = new KernelTransactionAccessor();
    private final TerminationFlagService terminationFlagService = new TerminationFlagService();
    private final UserAccessor userAccessor = new UserAccessor();
    private final Collection<Runnable> registrations = new ArrayList<Runnable>();
    private final Log log;
    private final GlobalProcedures globalProcedures;
    private final ConfigurationParser configurationParser;
    private final GraphStoreCatalogService graphStoreCatalogService;
    private final MemoryGauge memoryGauge;
    private final TaskStoreService taskStoreService;
    private final TaskRegistryFactoryService taskRegistryFactoryService;
    private final boolean useMaxMemoryEstimation;
    private final UserLogServices userLogServices;
    private final Lifecycle[] lifecycles;

    private ExtensionBuilder(Log log, GlobalProcedures globalProcedures, ConfigurationParser configurationParser, GraphStoreCatalogService graphStoreCatalogService, MemoryGauge memoryGauge, TaskStoreService taskStoreService, TaskRegistryFactoryService taskRegistryFactoryService, boolean useMaxMemoryEstimation, UserLogServices userLogServices, Lifecycle ... lifecycles) {
        this.log = log;
        this.globalProcedures = globalProcedures;
        this.configurationParser = configurationParser;
        this.graphStoreCatalogService = graphStoreCatalogService;
        this.memoryGauge = memoryGauge;
        this.taskStoreService = taskStoreService;
        this.taskRegistryFactoryService = taskRegistryFactoryService;
        this.useMaxMemoryEstimation = useMaxMemoryEstimation;
        this.userLogServices = userLogServices;
        this.lifecycles = lifecycles;
    }

    public static ExtensionBuilder create(Log log, Configuration neo4jConfiguration, GlobalProcedures globalProcedures) {
        Boolean progressTrackingEnabled = (Boolean)neo4jConfiguration.get(ProgressFeatureSettings.progress_tracking_enabled);
        log.info("Progress tracking: " + (progressTrackingEnabled != false ? "enabled" : "disabled"));
        Boolean useMaxMemoryEstimation = (Boolean)neo4jConfiguration.get(GdsSettings.validateUsingMaxMemoryEstimation());
        log.info("Memory usage guard: " + (useMaxMemoryEstimation != false ? "maximum" : "minimum") + " estimate");
        TaskStoreService taskStoreService = new TaskStoreService(progressTrackingEnabled.booleanValue());
        TaskRegistryFactoryService taskRegistryFactoryService = new TaskRegistryFactoryService(progressTrackingEnabled.booleanValue(), taskStoreService);
        UserLogServices userLogServices = new UserLogServices();
        GraphStoreCatalogService graphStoreCatalogService = new GraphStoreCatalogService();
        ConfigurationParser configurationParser = new ConfigurationParser(DefaultsConfiguration.Instance, LimitsConfiguration.Instance);
        AtomicLong freeMemoryAfterLastGc = new AtomicLong(Runtime.getRuntime().maxMemory());
        MemoryGauge memoryGauge = new MemoryGauge(freeMemoryAfterLastGc);
        GcListenerExtension.setMemoryGauge((AtomicLong)freeMemoryAfterLastGc);
        GcListenerInstaller gcListener = new GcListenerInstaller(log, ManagementFactory.getGarbageCollectorMXBeans(), freeMemoryAfterLastGc);
        return new ExtensionBuilder(log, globalProcedures, configurationParser, graphStoreCatalogService, memoryGauge, taskStoreService, taskRegistryFactoryService, useMaxMemoryEstimation, userLogServices, new Lifecycle[]{gcListener});
    }

    public <T> ExtensionBuilder withComponent(Class<T> cls, Supplier<ThrowingFunction<Context, T, ProcedureException>> provider) {
        this.registrations.add(() -> {
            this.log.info("Register " + cls.getSimpleName() + "...");
            this.globalProcedures.registerComponent(cls, (ThrowingFunction)provider.get(), true);
            this.log.info(cls.getSimpleName() + " registered.");
        });
        return this;
    }

    public Lifecycle registerExtension() {
        this.registrations.forEach(Runnable::run);
        TaskStoreProvider taskStoreProvider = new TaskStoreProvider(this.databaseIdAccessor, this.taskStoreService);
        TaskRegistryFactoryProvider taskRegistryFactoryProvider = new TaskRegistryFactoryProvider(this.databaseIdAccessor, this.userAccessor, this.taskRegistryFactoryService);
        UserLogRegistryFactoryProvider userLogRegistryFactoryProvider = new UserLogRegistryFactoryProvider(this.databaseIdAccessor, this.userAccessor, this.userLogServices);
        this.log.info("Register legacy Task Store/ Registry...");
        this.globalProcedures.registerComponent(TaskStore.class, (ThrowingFunction)taskStoreProvider, true);
        this.globalProcedures.registerComponent(TaskRegistryFactory.class, (ThrowingFunction)taskRegistryFactoryProvider, true);
        this.log.info("Task Store/ Registry registered.");
        this.log.info("Register legacy User Log Registry...");
        this.globalProcedures.registerComponent(UserLogRegistryFactory.class, (ThrowingFunction)userLogRegistryFactoryProvider, true);
        this.log.info("User Log Registry registered.");
        LifeSupport lifeSupport = new LifeSupport();
        for (Lifecycle lifecycle : this.lifecycles) {
            lifeSupport.add(lifecycle);
        }
        return lifeSupport;
    }

    public ThrowingFunction<Context, GraphDataScience, ProcedureException> gdsProvider(ExporterBuildersProviderService exporterBuildersProviderService, Optional<Function<CatalogBusinessFacade, CatalogBusinessFacade>> businessFacadeDecorator, MetricsFacade metricsFacade, Optional<Function<AlgorithmProcessingTemplate, AlgorithmProcessingTemplate>> algorithmProcessingTemplateDecorator, ModelCatalogServiceProvider modelCatalogServiceProvider) {
        CatalogFacadeProvider catalogFacadeProvider = this.createCatalogFacadeProvider(exporterBuildersProviderService, businessFacadeDecorator, metricsFacade.projectionMetrics());
        AlgorithmFacadeProviderFactory algorithmFacadeService = this.createAlgorithmService(metricsFacade.algorithmMetrics(), exporterBuildersProviderService, algorithmProcessingTemplateDecorator, modelCatalogServiceProvider);
        return new GraphDataScienceProvider(this.log, catalogFacadeProvider, algorithmFacadeService, metricsFacade.deprecatedProcedures());
    }

    private CatalogFacadeProvider createCatalogFacadeProvider(ExporterBuildersProviderService exporterBuildersProviderService, Optional<Function<CatalogBusinessFacade, CatalogBusinessFacade>> businessFacadeDecorator, ProjectionMetricsService projectionMetricsService) {
        CatalogFacadeProviderFactory catalogFacadeProviderFactory = new CatalogFacadeProviderFactory(this.log, exporterBuildersProviderService, businessFacadeDecorator);
        return catalogFacadeProviderFactory.createCatalogFacadeProvider(this.graphStoreCatalogService, this.databaseIdAccessor, this.kernelTransactionAccessor, this.taskRegistryFactoryService, projectionMetricsService, this.terminationFlagService, this.userLogServices, this.userAccessor);
    }

    private AlgorithmFacadeProviderFactory createAlgorithmService(AlgorithmMetricsService algorithmMetricsService, ExporterBuildersProviderService exporterBuildersProviderService, Optional<Function<AlgorithmProcessingTemplate, AlgorithmProcessingTemplate>> algorithmProcessingTemplateDecorator, ModelCatalogServiceProvider modelCatalogServiceProvider) {
        return new AlgorithmFacadeProviderFactory(this.log, this.configurationParser, this.graphStoreCatalogService, this.memoryGauge, this.useMaxMemoryEstimation, this.algorithmMetaDataSetterService, algorithmMetricsService, this.databaseIdAccessor, exporterBuildersProviderService, this.kernelTransactionAccessor, modelCatalogServiceProvider, this.taskRegistryFactoryService, this.terminationFlagService, this.userAccessor, this.userLogServices, algorithmProcessingTemplateDecorator);
    }
}

