/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.procedures.integration;

import java.util.Optional;
import java.util.function.Function;
import org.neo4j.gds.ProcedureCallContextReturnColumns;
import org.neo4j.gds.TransactionCloseableResourceRegistry;
import org.neo4j.gds.TransactionNodeLookup;
import org.neo4j.gds.algorithms.AlgorithmMemoryValidationService;
import org.neo4j.gds.algorithms.RequestScopedDependencies;
import org.neo4j.gds.algorithms.estimation.AlgorithmEstimator;
import org.neo4j.gds.algorithms.mutateservices.MutateNodePropertyService;
import org.neo4j.gds.algorithms.runner.AlgorithmRunner;
import org.neo4j.gds.algorithms.similarity.MutateRelationshipService;
import org.neo4j.gds.algorithms.similarity.WriteRelationshipService;
import org.neo4j.gds.algorithms.writeservices.WriteNodePropertyService;
import org.neo4j.gds.api.AlgorithmMetaDataSetter;
import org.neo4j.gds.api.CloseableResourceRegistry;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.NodeLookup;
import org.neo4j.gds.api.User;
import org.neo4j.gds.applications.algorithms.pathfinding.AlgorithmEstimationTemplate;
import org.neo4j.gds.applications.algorithms.pathfinding.AlgorithmProcessingTemplate;
import org.neo4j.gds.applications.algorithms.pathfinding.DefaultAlgorithmProcessingTemplate;
import org.neo4j.gds.applications.algorithms.pathfinding.DefaultMemoryGuard;
import org.neo4j.gds.applications.algorithms.pathfinding.MemoryGuard;
import org.neo4j.gds.core.loading.GraphStoreCatalogService;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.core.write.ExportBuildersProvider;
import org.neo4j.gds.core.write.ExporterContext;
import org.neo4j.gds.core.write.NodePropertyExporterBuilder;
import org.neo4j.gds.core.write.RelationshipExporterBuilder;
import org.neo4j.gds.core.write.RelationshipStreamExporterBuilder;
import org.neo4j.gds.logging.Log;
import org.neo4j.gds.mem.MemoryGauge;
import org.neo4j.gds.memest.DatabaseGraphStoreEstimationService;
import org.neo4j.gds.memest.FictitiousGraphStoreEstimationService;
import org.neo4j.gds.metrics.algorithms.AlgorithmMetricsService;
import org.neo4j.gds.modelcatalogservices.ModelCatalogServiceProvider;
import org.neo4j.gds.procedures.KernelTransactionAccessor;
import org.neo4j.gds.procedures.TaskRegistryFactoryService;
import org.neo4j.gds.procedures.TerminationFlagService;
import org.neo4j.gds.procedures.algorithms.ConfigurationCreator;
import org.neo4j.gds.procedures.configparser.ConfigurationParser;
import org.neo4j.gds.procedures.integration.AlgorithmMetaDataSetterService;
import org.neo4j.gds.procedures.integration.AlgorithmProcedureFacadeProvider;
import org.neo4j.gds.procedures.integration.ExporterBuildersProviderService;
import org.neo4j.gds.procedures.integration.GraphLoaderContextProvider;
import org.neo4j.gds.services.DatabaseIdAccessor;
import org.neo4j.gds.services.UserAccessor;
import org.neo4j.gds.services.UserLogServices;
import org.neo4j.gds.termination.TerminationFlag;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

class AlgorithmFacadeProviderFactory {
    private final FictitiousGraphStoreEstimationService fictitiousGraphStoreEstimationService = new FictitiousGraphStoreEstimationService();
    private final Log log;
    private final ConfigurationParser configurationParser;
    private final GraphStoreCatalogService graphStoreCatalogService;
    private final MemoryGauge memoryGauge;
    private final boolean useMaxMemoryEstimation;
    private final AlgorithmMetaDataSetterService algorithmMetaDataSetterService;
    private final AlgorithmMetricsService algorithmMetricsService;
    private final DatabaseIdAccessor databaseIdAccessor;
    private final ExporterBuildersProviderService exporterBuildersProviderService;
    private final KernelTransactionAccessor kernelTransactionAccessor;
    private final TaskRegistryFactoryService taskRegistryFactoryService;
    private final TerminationFlagService terminationFlagService;
    private final UserAccessor userAccessor;
    private final UserLogServices userLogServices;
    private final ModelCatalogServiceProvider modelCatalogServiceProvider;
    private final Optional<Function<AlgorithmProcessingTemplate, AlgorithmProcessingTemplate>> algorithmProcessingTemplateDecorator;

    AlgorithmFacadeProviderFactory(Log log, ConfigurationParser configurationParser, GraphStoreCatalogService graphStoreCatalogService, MemoryGauge memoryGauge, boolean useMaxMemoryEstimation, AlgorithmMetaDataSetterService algorithmMetaDataSetterService, AlgorithmMetricsService algorithmMetricsService, DatabaseIdAccessor databaseIdAccessor, ExporterBuildersProviderService exporterBuildersProviderService, KernelTransactionAccessor kernelTransactionAccessor, ModelCatalogServiceProvider modelCatalogServiceProvider, TaskRegistryFactoryService taskRegistryFactoryService, TerminationFlagService terminationFlagService, UserAccessor userAccessor, UserLogServices userLogServices, Optional<Function<AlgorithmProcessingTemplate, AlgorithmProcessingTemplate>> algorithmProcessingTemplateDecorator) {
        this.log = log;
        this.configurationParser = configurationParser;
        this.graphStoreCatalogService = graphStoreCatalogService;
        this.memoryGauge = memoryGauge;
        this.useMaxMemoryEstimation = useMaxMemoryEstimation;
        this.algorithmMetaDataSetterService = algorithmMetaDataSetterService;
        this.databaseIdAccessor = databaseIdAccessor;
        this.kernelTransactionAccessor = kernelTransactionAccessor;
        this.exporterBuildersProviderService = exporterBuildersProviderService;
        this.taskRegistryFactoryService = taskRegistryFactoryService;
        this.algorithmMetricsService = algorithmMetricsService;
        this.terminationFlagService = terminationFlagService;
        this.userLogServices = userLogServices;
        this.userAccessor = userAccessor;
        this.algorithmProcessingTemplateDecorator = algorithmProcessingTemplateDecorator;
        this.modelCatalogServiceProvider = modelCatalogServiceProvider;
    }

    AlgorithmProcedureFacadeProvider createAlgorithmFacadeProvider(Context context) throws ProcedureException {
        GraphDatabaseAPI graphDatabaseService = context.graphDatabaseAPI();
        KernelTransaction kernelTransaction = this.kernelTransactionAccessor.getKernelTransaction(context);
        AlgorithmMetaDataSetter algorithmMetaDataSetter = this.algorithmMetaDataSetterService.getAlgorithmMetaDataSetter(kernelTransaction);
        AlgorithmMemoryValidationService algorithmMemoryValidationService = new AlgorithmMemoryValidationService(this.log, this.useMaxMemoryEstimation);
        TransactionCloseableResourceRegistry closeableResourceRegistry = new TransactionCloseableResourceRegistry(kernelTransaction);
        DatabaseId databaseId = this.databaseIdAccessor.getDatabaseId((GraphDatabaseService)context.graphDatabaseAPI());
        ExportBuildersProvider exportBuildersProvider = this.exporterBuildersProviderService.identifyExportBuildersProvider((GraphDatabaseService)graphDatabaseService);
        ExporterContext.ProcedureContextWrapper exporterContext = new ExporterContext.ProcedureContextWrapper(context);
        DefaultMemoryGuard memoryGuard = new DefaultMemoryGuard(this.log, this.useMaxMemoryEstimation, this.memoryGauge);
        MutateNodePropertyService mutateNodePropertyService = new MutateNodePropertyService(this.log);
        MutateRelationshipService mutateRelationshipService = new MutateRelationshipService(this.log);
        TransactionNodeLookup nodeLookup = new TransactionNodeLookup(kernelTransaction);
        ProcedureCallContextReturnColumns returnColumns = new ProcedureCallContextReturnColumns(context.procedureCallContext());
        TerminationFlag terminationFlag = this.terminationFlagService.createTerminationFlag(kernelTransaction);
        User user = this.userAccessor.getUser(context.securityContext());
        TaskRegistryFactory taskRegistryFactory = this.taskRegistryFactoryService.getTaskRegistryFactory(databaseId, user);
        UserLogRegistryFactory userLogRegistryFactory = this.userLogServices.getUserLogRegistryFactory(databaseId, user);
        ConfigurationCreator configurationCreator = new ConfigurationCreator(this.configurationParser, algorithmMetaDataSetter, user);
        GraphLoaderContext graphLoaderContext = GraphLoaderContextProvider.buildGraphLoaderContext(context, databaseId, taskRegistryFactory, terminationFlag, userLogRegistryFactory, this.log);
        NodePropertyExporterBuilder nodePropertyExporterBuilder = exportBuildersProvider.nodePropertyExporterBuilder((ExporterContext)exporterContext);
        RelationshipExporterBuilder relationshipExporterBuilder = exportBuildersProvider.relationshipExporterBuilder((ExporterContext)exporterContext);
        RelationshipStreamExporterBuilder relationshipStreamExporterBuilder = exportBuildersProvider.relationshipStreamExporterBuilder((ExporterContext)exporterContext);
        RequestScopedDependencies requestScopedDependencies = RequestScopedDependencies.builder().with(databaseId).with(user).with(terminationFlag).build();
        WriteNodePropertyService writeNodePropertyService = new WriteNodePropertyService(this.log, nodePropertyExporterBuilder, taskRegistryFactory, terminationFlag);
        WriteRelationshipService writeRelationshipService = new WriteRelationshipService(this.log, relationshipExporterBuilder, taskRegistryFactory, terminationFlag);
        DatabaseGraphStoreEstimationService databaseGraphStoreEstimationService = new DatabaseGraphStoreEstimationService(graphLoaderContext, user);
        AlgorithmEstimator algorithmEstimator = new AlgorithmEstimator(this.graphStoreCatalogService, this.fictitiousGraphStoreEstimationService, databaseGraphStoreEstimationService, databaseId, user);
        AlgorithmRunner algorithmRunner = new AlgorithmRunner(this.log, this.graphStoreCatalogService, this.algorithmMetricsService, algorithmMemoryValidationService, requestScopedDependencies, taskRegistryFactory, userLogRegistryFactory);
        DefaultAlgorithmProcessingTemplate algorithmProcessingTemplate = new DefaultAlgorithmProcessingTemplate(this.log, this.algorithmMetricsService, this.graphStoreCatalogService, (MemoryGuard)memoryGuard, databaseId, user);
        if (this.algorithmProcessingTemplateDecorator.isPresent()) {
            algorithmProcessingTemplate = this.algorithmProcessingTemplateDecorator.get().apply((AlgorithmProcessingTemplate)algorithmProcessingTemplate);
        }
        AlgorithmEstimationTemplate algorithmEstimationTemplate = new AlgorithmEstimationTemplate(this.graphStoreCatalogService, databaseId, databaseGraphStoreEstimationService, this.fictitiousGraphStoreEstimationService, user);
        return new AlgorithmProcedureFacadeProvider(this.log, (CloseableResourceRegistry)closeableResourceRegistry, configurationCreator, (NodeLookup)nodeLookup, returnColumns, mutateNodePropertyService, writeNodePropertyService, mutateRelationshipService, writeRelationshipService, algorithmRunner, algorithmEstimator, (AlgorithmProcessingTemplate)algorithmProcessingTemplate, algorithmEstimationTemplate, relationshipStreamExporterBuilder, taskRegistryFactory, terminationFlag, userLogRegistryFactory, this.modelCatalogServiceProvider.createService((GraphDatabaseService)graphDatabaseService, this.log));
    }
}

